// Variables used by Scriptable.
// These must be at the very top of the file. Do not edit.
// icon-color: blue; icon-glyph: feather-alt;
/*
// 抖音搜索：大舅哥科技
// 微信搜索公众号「大舅哥科技」
// 获取更多精美实用 iOS 桌面组件！
// 更多精选快捷指令、壁纸，等你！
// ***************************
// 环境框架   ：@ DmYY  
// author 	 ：原作者2Ya 由DJG修改
*/

const { DJG, Runing } = importModule(
	FileManager.local().joinPath(
		FileManager.local().libraryDirectory(),
		"/DJG.js"
	)
);

// @组件代码开始
class Widget extends DJG {
	constructor(arg) {
		super(arg);
		this.name = '百度热榜'
		this.widget_ID = "DJG-111"
		this.version = "V3.7"
		this.logo = 'https://www.baidu.com/cache/icon/favicon.ico'

		this.Run(module.filename, args);
	}

	/**
	 * 渲染函数，函数名固定
	 * 可以根据 this.widgetFamily 来判断小组件尺寸，以返回不同大小的内容
	 */
	async render() {
		let widget = this.getWidget();
		await this.getWidgetBackgroundImage(widget);

		// 使用动态颜色自动响应深色模式切换
		widget.backgroundColor = Color.dynamic(new Color("#f6f6f6"), new Color("#1e293b"));
		try {
			let data = await this.getData()
			switch (this.widgetFamily) {
				case 'small':
					await this.renderSmall(widget, data);
					break;
				case 'medium':
					await this.renderMedium(widget, data);
					break;
				default:
					await this.renderMedium(widget, data, 13);
					break;
			}
		} catch (e) {
			this.ERROR.push({ error: e.toString() });
		}
		return widget;
	}

	// 小组件
	async renderSmall(w, data) {
		await this.renderHeader(w, this.logo, this.name)
		const cell = w.addStack()

		// 添加排名（使用原生API + 动态颜色）
		const rankText = cell.addText('1');
		rankText.font = Font.lightSystemFont(14);
		rankText.textColor = Color.dynamic(new Color("#fe2d46"), new Color("#ff6b6b"));

		cell.addSpacer(8);
		let title = data['hotsearch'][0]['pure_title'] || data['hotsearch'][0]['card_title']

		// 添加标题（使用原生API + 动态颜色）
		const titleText = cell.addText(title);
		titleText.font = Font.lightSystemFont(13);
		titleText.textColor = Color.dynamic(new Color("#000000"), new Color("#ffffff"));

		w.addSpacer()
		let url = decodeURIComponent(data['hotsearch'][0]['linkurl'])
		url = url.replace("://www.", "://m.")
		let score = data['hotsearch'][0]['heat_score']

		// 添加分数（使用原生API + 动态颜色）
		const scoreText = w.addText(`      ${score}`);
		scoreText.font = Font.lightSystemFont(10);
		scoreText.textColor = Color.dynamic(new Color("#666666"), new Color("#999999"));
		scoreText.url = url;
	}

	// 中组件
	async renderMedium(w, data, num = 5) {
		w.addSpacer(5);
		await this.renderHeader(w, this.logo, this.name, 8)
		data['hotsearch'].slice(0, num).map((d, i) => {
			const cell = w.addStack();
			cell.centerAlignContent();

			// 添加排名（使用原生API + 动态颜色）
			const rankText = cell.addText(String(i + 1));
			rankText.font = Font.boldSystemFont(13);
			// 根据排名设置不同颜色
			if (i === 0) {
				rankText.textColor = Color.dynamic(new Color("#fe2d46"), new Color("#ff6b6b"));
			} else if (i === 1) {
				rankText.textColor = Color.dynamic(new Color("#ff6600"), new Color("#ff922b"));
			} else if (i === 2) {
				rankText.textColor = Color.dynamic(new Color("#faa90e"), new Color("#fbbf24"));
			} else {
				rankText.textColor = Color.dynamic(new Color("#9195a3"), new Color("#94a3b8"));
			}

			cell.addSpacer(10)
			let title = d['pure_title'] || d['card_title']

			// 添加标题（使用原生API + 动态颜色）
			const titleText = cell.addText(title);
			titleText.font = Font.lightSystemFont(13);
			titleText.textColor = Color.dynamic(new Color("#000000"), new Color("#ffffff"));
			titleText.lineLimit = 1;

			cell.addSpacer()
			let score = d['heat_score']

			// 添加分数（使用原生API + 动态颜色）
			const scoreText = cell.addText(score);
			scoreText.font = Font.lightSystemFont(10);
			scoreText.textColor = Color.dynamic(new Color("#666666"), new Color("#999999"));

			let url = decodeURIComponent(d['linkurl'])
			url = url.replace("://www.", "://m.")
			cell.url = url
			w.addSpacer(6)
		})
	}

	/**
	 * 获取数据函数，函数名可不固定
	 */

	async getData() {
		const options = {
			headers: {
				'User-Agent': "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.67 Safari/537.36 Edg/87.0.664.55"
			}
		}
		let data = await this.httpGet("https://www.baidu.com/", false, true, options)
		const tmp = data.split(`<textarea id="hotsearch_data" style="display:none;">`)[1].split(`</textarea>`)[0]
		data = eval(`(${tmp})`);
		return data
	}

	actionUrl(name = '', data = '') {
		let u = URLScheme.forRunningScript()
		let q = `act=${encodeURIComponent(name)}&data=${encodeURIComponent(data)}&__arg=${encodeURIComponent(this.arg)}&__size=${this.widgetFamily}`
		let result = ''
		if (u.includes('run?')) {
			result = `${u}&${q}`
		} else {
			result = `${u}?${q}`
		}
		return result
	}

	// 添加设置信息
	Run(filename, args) {
		if (config.runsInApp) {
			this.registerAction("基础设置", this.setWidgetConfig);
		}
	}
}

// @组件代码结束
await Runing(Widget)