// Variables used by Scriptable.
// These must be at the very top of the file. Do not edit.
// icon-color: blue; icon-glyph: feather-alt;
/*
// 抖音搜索：大舅哥科技
// 微信搜索公众号「大舅哥科技」
// 获取更多精美实用 iOS 桌面组件！
// 更多精选快捷指令、壁纸，等你！
// ***************************
// 环境框架   ：@ DmYY  
// author 	 ：@ DJG
*/

const { DJG, Runing } = importModule(
  FileManager.local().joinPath(
    FileManager.local().libraryDirectory(),
    "/DJG.js"
  )
);

// @组件代码开始
class Widget extends DJG {
  constructor(arg) {
    super(arg);
    this.name = '实时油价'
    this.desc = '展示汽油价格信息'
    this.widget_ID = "DJG-108"
    this.version = "V3.6"
    this.logo = "https://s1.ax1x.com/2022/07/10/jrjs2D.png"

    this.Run(module.filename, args);
  }
  
  /**
   * 渲染函数，函数名固定
   * 可以根据 this.widgetFamily 来判断小组件尺寸，以返回不同大小的内容
   */
  async render () {
    let widget = this.getWidget();
    await this.getWidgetBackgroundImage(widget);
    if (!this.settings.oilpriceKEY) {
      if(config.runsInWidget) return await this.renderAlert('需要申请 \'实时油价\' key');
      return await this.inputKey();;
    }
    try{
      await this.getData()
      switch (this.widgetFamily) {
        case 'small':
        	await this.renderSmall(widget);
        	break;
        case 'medium':
        	await this.renderMedium(widget);
        	break;
        default:
        	return await this.renderAlert();
      }
    }catch(e){
      this.ERROR.push({error:e.toString()});
    }
    return widget;
  }
  
  // 小组件
  async renderSmall (w) {
    await this.renderHeader(w, this.logo, this.name)
    const mediumStack = w.addStack()
    mediumStack.layoutVertically()
    const title = ["92#  ","95#  ","98#  "," 0#    "]
    const oilprice = this.settings.oilprice;
    const oilpriceArr = [oilprice.p92, oilprice.p95, oilprice.p98, oilprice.p0];
    for(let j = 0; j < 4; j++){
      this.addText(mediumStack, title[j]+oilpriceArr[j], 15, {color:'FF7F24'})
      mediumStack.addSpacer(3) 
    }
    w.addSpacer()
    const update = w.addStack()
    update.addSpacer()
    let time = this.getDateStr("MM-dd HH:mm:ss");
    this.addText(update, time, 11, {opacity:0.8})
    update.addSpacer()
  }
  // 中组件
  async renderMedium(w){
    const oilprice = this.settings.oilprice;
    await this.renderHeader(w, this.logo, `${this.name}•${oilprice.prov}`)
    w.addSpacer(10)

    const mediumStack = w.addStack()
    const title = ["92#","95#","98#","0#"];
    const oilpriceArr = [oilprice.p92, oilprice.p95, oilprice.p98, oilprice.p0];
    for(let j = 0; j < 4; j++){
      mediumStack.addSpacer()
      const stack = mediumStack.addStack()
      stack.layoutVertically()
      stack.centerAlignContent()
      this.addText(stack, title[j], 25, {font:'bold', color:'FF7F24'})
      stack.addSpacer(7)
      this.addText(stack, '¥'+oilpriceArr[j], 15, {font:'bold'})
      mediumStack.addSpacer() 
    }
    w.addSpacer()
    const update = w.addStack()
    update.addSpacer()
    let time = this.getDateStr("yyyy-MM-dd HH:mm:ss");
    this.addText(update, time, 12, {opacity:0.8})
    update.addSpacer()
  }
 
  /**
   * 获取数据
   */
  async getData(){
    const loc = await this.getLocation();
    let req = loc.administrativeArea || loc.locality;
    let city = req.replace(/市|省|壮族自治区|回族自治区|维吾尔自治区|自治区/,"");
    let cityEncode = encodeURI(city);
    const api = "http://api.tianapi.com/oilprice/index";
    let data = await this.httpGet(`${api}?key=${this.settings.oilpriceKEY}&prov=${cityEncode}`);
    if(data.code != 200) return this.ERROR = [{error:data.msg}];
    if(!data.newslist[0].p92) return;
    this.settings.oilprice = data.newslist[0];
    this.saveSettings(false);
  }
  
  // 天行数据
  async inputKey(){
    const message = '申请\'实时油价\'key';
    const idx = await this.generateAlert(message, ['申请key','输入key']);
    if(idx === 0) return await Safari.open('https://www.tianapi.com/login.html');
    await this.setCustomAction("实时油价key", "请正确输入油价key", {
      oilpriceKEY: "此处输入key",
    });
  }
  
  // 添加设置信息
  Run(filename, args) {
    if (config.runsInApp) {
      this.registerAction("基础设置", this.setWidgetConfig);
      this.registerAction("天行数据", async () => {
        await this.inputKey();
      }, { name: 'key.icloud', color: '#B8860B' });
    }
  }
}
// @组件代码结束
await Runing(Widget)