// Variables used by Scriptable.
// These must be at the very top of the file. Do not edit.
// icon-color: blue; icon-glyph: feather-alt;
/*
// 抖音搜索：大舅哥科技
// 微信搜索公众号「大舅哥科技」
// 获取更多精美实用 iOS 桌面组件！
// 更多精选快捷指令、壁纸，等你！
// ***************************
// 环境框架   ：@ DmYY  
// author 	 ：作者不明，DJG修改
*/

const { DJG, Runing } = importModule(
  FileManager.local().joinPath(
    FileManager.local().libraryDirectory(),
    "/DJG.js"
  )
);

// @组件代码开始
class Widget extends DJG {
  constructor (arg) {
    super(arg)
    this.name = '微博热榜'
    this.widget_ID = "DJG-104"
    this.version = "V3.5";
    this.apiUrl = "https://m.weibo.cn/api/container/getIndex?containerid=106003%26filter_type%3Drealtimehot";
    this.logo = "https://s1.ax1x.com/2022/07/10/jrj056.png";

    this.Run();
  }
  
  async render () {
    let widget = this.getWidget();
    await this.getWidgetBackgroundImage(widget);
    if(!this.settings.choiceAction) this.settings.choiceAction = "b";
    try{
      switch (this.widgetFamily) {
        case 'small':
        	await this.renderSmall(widget);
        	break;
        case 'medium':
        	await this.renderMedium(widget);
        	break;
        default:
        	await this.renderMedium(widget, 13);
        	break;
      }
    }catch(e){
      this.ERROR.push({error:e.toString()});
    }
    return widget;
  }
  
  returnUrl(url) {
    const optionStatus = this.settings.optionStatus || [false, true];
    if (optionStatus[1]) {
      return url;
    } else {
      let k = decodeURIComponent(url).split('q=')[1].split('&')[0];
      return 'vvebo://search?q=' + encodeURIComponent(k);
    }
  }
  
  /**
   * 渲染小尺寸组件
   */
  async renderSmall (w) {
    let res = await this.httpGet(this.apiUrl);
    let data = res['data']['cards'][0]['card_group']
    // 去除第一条
    data.shift();
    let topic = data[0]
    // 显示数据
    await this.renderHeader(w, this.logo, '微博热搜')
    let body = w.addStack();
    this.addText(body, topic['desc'], 13, {font:'light', align:'left'});

    w.addSpacer()
    let footer = w.addStack()
    footer.centerAlignContent()
    let img = footer.addImage(await this.getImageByUrl(topic['pic']))
    img.imageSize = new Size(18, 18)
    footer.addSpacer(5)
    if (topic['icon']) {
      let hot = footer.addImage(await this.getImageByUrl(topic['icon']))
      hot.imageSize = new Size(18, 18)
      footer.addSpacer(5)
    }
    this.addText(footer, String(topic['desc_extr']), 10, {font:'light', opacity:0.5});
  }
  /**
   * 渲染中尺寸组件
   */
  async renderMedium (w, count = 5) {
    let res = await this.httpGet(this.apiUrl)
    let data = res['data']['cards'][0]['card_group'];
    // 去除第一条
    data.shift();
    // 显示数据
    w.addSpacer(5);
    w = await this.renderHeader(w, this.logo, '微博热搜', 8)
    // 布局：一行一个，左边顺序排序，中间标题，后边热/新
    const body = w.addStack()
    const bodyLeft = body.addStack()
    bodyLeft.layoutVertically()
    let index = 0;
    for (let i = 0; i < count; i ++) {
      let topic = data[i+index];
      if(!topic['desc_extr']) {
        index++;
      }
      topic = data[i+index]
      let dom = bodyLeft.addStack()
      dom.centerAlignContent()
      let pic = dom.addImage(await this.getImageByUrl(topic['pic']))
      pic.imageSize = new Size(19, 19)
      dom.addSpacer(5)
      this.addText(dom, topic['desc'], 13, {font:'light', lineLimit:1});
      dom.addSpacer(5)
      if (topic['icon']) {
        let iconDom = dom.addStack()
        let icon = iconDom.addImage(await this.getImageByUrl(topic['icon']))
        icon.imageSize = new Size(18, 18)
      }
      dom.addSpacer()
      this.addText(dom, String(topic['desc_extr']), 11, {font:'light', opacity:0.6});
      dom.url = this.returnUrl(topic['scheme'])
      bodyLeft.addSpacer(4)
    }
    body.addSpacer()
  }
  
  // 添加设置信息
  Run(filename, args) {
    if (config.runsInApp) {
      this.registerAction("基础设置", this.setWidgetConfig);
    }
    this.registerAction("打开方式", async () => {
        await this.setChoiceAction("打开方式", "点击小组件浏览热点的方式", [
          '客户端','wab网页'
        ]);
      }, { name: 'tray.2.fill', color: '#7B68EE' });
  }
}
// @组件代码结束
await Runing(Widget)
