// Variables used by Scriptable.
// These must be at the very top of the file. Do not edit.
// icon-color: teal; icon-glyph: magic;
const TOPHUB_URL = 'https://tophub.today/n/mproPpoq6O';
const ZHIHU_ICON_URL = 'https://static.zhihu.com/heifetz/favicon.ico';
let zhihuIconImage = null;

// 动态颜色函数（支持夜间模式）
function dynamicColor(lightColor, darkColor) {
	return Color.dynamic(new Color(lightColor), new Color(darkColor));
}

async function fetchTopHubHot() {
	const req = new Request(TOPHUB_URL);
	req.headers = {
		'User-Agent': 'Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 Scriptable',
		'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
	};
	const html = await req.loadString();

	const items = [];
	let m;
	const anchorRegex = /<a[^>]*href="(https?:\/\/[^"]*zhihu\.com\/question\/\d+[^"]*)"[^>]*>([\s\S]*?)<\/a>/gi;
	while ((m = anchorRegex.exec(html)) !== null) {
		const link = m[1];
		const tag = m[0];
		const titleAttrMatch = /title="([^"]+)"/i.exec(tag);
		const inner = m[2];
		let rawTitle = (titleAttrMatch ? titleAttrMatch[1] : stripTags(inner)).trim();
		rawTitle = sanitizeTitle(rawTitle);
		let title = decodeHTML(rawTitle);
		const ctx = html.slice(m.index, Math.min(html.length, m.index + 300));
		let heat = extractHeat(ctx);
		if (!isMeaningfulTitle(title)) {
			const fetched = await fetchZhihuTitle(link);
			if (fetched) title = fetched;
		}
		if (!isMeaningfulTitle(title)) continue;
		if (items.find(it => it.title === title)) continue; // 去重
		items.push({ title, link, heat });
		if (items.length >= 50) break;
	}

	if (items.length === 0) {
		const altRegex = /<a[^>]+class="(?:tlink|el-title)[^"]*"[^>]+href="([^"]+)"[^>]*>([\s\S]*?)<\/a>/gi;
		while ((m = altRegex.exec(html)) !== null) {
			const link = m[1];
			if (!/zhihu\.com\/question\//.test(link)) continue;
			const tag = m[0];
			const titleAttrMatch = /title="([^"]+)"/i.exec(tag);
			let rawTitle = (titleAttrMatch ? titleAttrMatch[1] : stripTags(m[2])).trim();
			rawTitle = sanitizeTitle(rawTitle);
			let title = decodeHTML(rawTitle);
			const ctx = html.slice(m.index, Math.min(html.length, m.index + 300));
			let heat = extractHeat(ctx);
			if (!isMeaningfulTitle(title)) {
				const fetched = await fetchZhihuTitle(link);
				if (fetched) title = fetched;
			}
			if (!isMeaningfulTitle(title)) continue;
			if (items.find(it => it.title === title)) continue;
			items.push({ title, link, heat });
			if (items.length >= 50) break;
		}
	}

	return items;
}

function stripTags(s) { return s.replace(/<[^>]*>/g, ''); }
function sanitizeTitle(s) {
	return s
		.replace(/^\d+\.?\s*/, '')
		.replace(/\s*…\s*$/, '')
		.replace(/\s*\.\.\.\s*$/, '')
		.trim();
}
function decodeHTML(s) {
	const entities = {
		'&amp;': '&', '&lt;': '<', '&gt;': '>', '&quot;': '"', '&#39;': '\'',
		'&nbsp;': ' ', '&#8212;': '—', '&#8211;': '–'
	};
	return s.replace(/&[a-zA-Z0-9#]+;/g, (e) => entities[e] || e);
}

function extractHeat(context) {
	const r1 = /(\d[\d,\.]*)(?:\s*(万|亿))?\s*热度?/i.exec(context);
	if (r1) {
		const num = r1[1].replace(/,/g, '');
		const unit = r1[2] || '';
		return unit ? `${num}${unit}` : num;
	}
	return '';
}

function isMeaningfulTitle(s) {
	if (!s) return false;
	const t = s.trim();
	if (!t || t.length < 4) return false;
	if (/^\d+\.?$/.test(t)) return false;
	if (t === '...' || /^(\.\.\.|…)$/.test(t)) return false;
	return /[^\d\s\.]/.test(t);
}

async function fetchZhihuTitle(link) {
	try {
		const r = new Request(link);
		r.headers = {
			'User-Agent': 'Mozilla/5.0 (iPhone; CPU iPhone OS 16_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 Scriptable',
			'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
			'Referer': 'https://tophub.today/'
		};
		const html = await r.loadString();
		let m = /<title>([\s\S]*?)<\/title>/i.exec(html);
		if (m && m[1]) {
			let t = m[1].replace(/\s*-\s*知乎.*/, '').trim();
			t = decodeHTML(stripTags(t));
			t = sanitizeTitle(t);
			if (isMeaningfulTitle(t)) return t;
		}
		m = /QuestionHeader-title["'>][\s\S]*?<h1[^>]*>([\s\S]*?)<\/h1>/i.exec(html);
		if (m && m[1]) {
			let t = decodeHTML(stripTags(m[1]));
			t = sanitizeTitle(t);
			if (isMeaningfulTitle(t)) return t;
		}
	} catch (_) { }
	return '';
}

function rankColor(i) {
	if (i === 0) return dynamicColor('#fe2d46', '#ff4757');
	if (i === 1) return dynamicColor('#ff6600', '#ff8c42');
	if (i === 2) return dynamicColor('#faa90e', '#ffab0f');
	return dynamicColor('#9195a3', '#a4b0be');
}

async function addHeader(w) {
	w.addSpacer(12);
	const head = w.addStack();
	head.setPadding(0, 12, 0, 12);
	head.centerAlignContent();
	try {
		if (!zhihuIconImage) {
			const r = new Request(ZHIHU_ICON_URL);
			zhihuIconImage = await r.loadImage();
		}
		const img = head.addImage(zhihuIconImage);
		img.imageSize = new Size(16, 16);
	} catch (e) {
		const icon = SFSymbol.named('globe');
		const img = head.addImage(icon.image);
		img.tintColor = dynamicColor('#2a74e6', '#5a9eff');
		img.imageSize = new Size(16, 16);
	}
	head.addSpacer(6);
	const title = head.addText('知乎热榜');
	title.font = Font.boldSystemFont(13);
	title.textColor = dynamicColor('#333333', '#ffffff');
	head.addSpacer();
	const timeStack = head.addStack();
	timeStack.addSpacer(4);
	const updateText = timeStack.addText('更新于 ');
	updateText.font = Font.systemFont(10);
	updateText.textColor = dynamicColor('#666666', '#999999');
	updateText.textOpacity = 0.5;
	const time = timeStack.addText(formatTime(new Date()));
	time.font = Font.systemFont(10);
	time.textColor = dynamicColor('#666666', '#999999');
	time.textOpacity = 0.5;
	w.addSpacer(12);
}

function formatTime(d) {
	const hh = String(d.getHours()).padStart(2, '0');
	const mm = String(d.getMinutes()).padStart(2, '0');
	return `${hh}:${mm}`;
}

async function renderSmall(items) {
	const w = new ListWidget();
	w.setPadding(8, 8, 8, 8);
	w.backgroundColor = dynamicColor('#f3f8ff', '#1e293b');
	await addHeader(w);
	if (!items || items.length === 0) {
		const t = w.addText('暂无数据');
		t.font = Font.systemFont(12);
		t.textColor = dynamicColor('#666666', '#999999');
		t.textOpacity = 0.7;
		return w;
	}
	const item = items[0];
	const card = w.addStack();
	card.layoutVertically();
	card.backgroundColor = dynamicColor('#f3f8ff', '#1e293b');
	card.cornerRadius = 16;
	card.setPadding(10, 12, 10, 12);

	const row = card.addStack();
	row.centerAlignContent();
	const idx = row.addText('1');
	idx.font = Font.boldSystemFont(13);
	idx.textColor = rankColor(0);
	row.addSpacer(8);
	const tt = row.addText(item.title);
	tt.font = Font.systemFont(13);
	tt.textColor = dynamicColor('#333333', '#ffffff');
	tt.lineLimit = 1;
	row.addSpacer();
	const heat = row.addText(item.heat || '');
	heat.font = Font.systemFont(10);
	heat.textColor = dynamicColor('#999999', '#666666');
	heat.textOpacity = 0.6;
	row.addSpacer(4);
	card.url = item.link;
	return w;
}

async function renderMedium(items, num = 5) {
	const w = new ListWidget();
	w.setPadding(8, 8, 8, 8);
	w.backgroundColor = dynamicColor('#f3f8ff', '#1e293b');
	await addHeader(w);
	if (!items || items.length === 0) {
		const t = w.addText('暂无数据');
		t.font = Font.systemFont(12);
		t.textColor = dynamicColor('#666666', '#999999');
		t.textOpacity = 0.7;
		return w;
	}

	// 添加列表容器
	const contentStack = w.addStack();
	contentStack.layoutVertically();
	contentStack.setPadding(0, 12, 0, 12);

	const list = items.slice(0, num);
	for (let i = 0; i < list.length; i++) {
		const d = list[i];
		const row = contentStack.addStack();
		row.centerAlignContent();
		const idx = row.addText(String(i + 1));
		idx.font = Font.boldSystemFont(13);
		idx.textColor = rankColor(i);
		row.addSpacer(8);
		const tt = row.addText(d.title);
		tt.font = Font.systemFont(13);
		tt.textColor = dynamicColor('#333333', '#ffffff');
		tt.lineLimit = 1;
		row.addSpacer();
		const heat = row.addText(d.heat || '');
		heat.font = Font.systemFont(10);
		heat.textColor = dynamicColor('#999999', '#666666');
		heat.textOpacity = 0.6;
		row.url = d.link;
		if (i < list.length - 1) {
			contentStack.addSpacer(6);
		}
	}

	w.addSpacer(12);
	return w;
}

async function createWidget() {
	try {
		const items = await fetchTopHubHot();
		const fam = config.widgetFamily;
		if (fam === 'small') {
			return await renderSmall(items);
		} else {
			return await renderMedium(items, fam === 'medium' ? 5 : 13);
		}
	} catch (e) {
		const w = new ListWidget();
		w.setPadding(12, 12, 12, 12);
		w.backgroundColor = dynamicColor('#f3f8ff', '#1e293b');
		const t = w.addText('加载失败');
		t.font = Font.boldSystemFont(12);
		t.textColor = dynamicColor('#333333', '#ffffff');
		const m = w.addText(String(e));
		m.font = Font.systemFont(10);
		m.textColor = dynamicColor('#666666', '#999999');
		m.textOpacity = 0.7;
		return w;
	}
}

const widget = await createWidget();
if (config.runsInWidget) {
	Script.setWidget(widget);
} else {
	await widget.presentLarge();
	Script.setWidget(widget);
}
Script.complete();