// Variables used by Scriptable.
// These must be at the very top of the file. Do not edit.
// icon-color: light-brown; icon-glyph: magic;
// Variables used by Scriptable.
// These must be at the very top of the file. Do not edit.
// icon-color: blue; icon-glyph: magic;
// Variables used by Scriptable.
// These must be at the very top of the file. Do not edit.
// icon-color: blue; icon-glyph: gas-pump;
const img = {
    "0": "https://img10.360buyimg.com/img//jfs/t1/221304/40/11509/28222/6218c86aE8324e61c/fb58efc3c791e246.jpg",
    "89": "https://img1.360buyimg.com/img//jfs/t1/144816/36/23065/30647/6218c89fE2cce3e86/3563ac19aa88f737.jpg",
    "92": "https://img10.360buyimg.com/img//jfs/t1/131681/3/25118/30651/6218c8a6Efc4f856f/471c52dd8b7f31d6.jpg",
    "95": "https://img11.360buyimg.com/img//jfs/t1/107723/26/24197/30128/6218c8afE4fa49b98/fa9944c2c5f76631.jpg",
    "medium": "https://img1.360buyimg.com/img//jfs/t1/166560/4/28704/187895/6220b25fE632ef97d/017916d5dc894769.jpg",
    "large": "https://img10.360buyimg.com/img//jfs/t1/219284/18/13530/396196/6220ba32Ea215b954/e311611cc0b1c7c0.jpg"
}

const base_api = "https://oil-price.vercel.app/api/oil?"

if (config.runsInWidget) {
    let widget
    Location.setAccuracyToHundredMeters()
    const location = await Location.current()
        .catch(async err => {
            if (config.runsInWidget) { widget = await renderError("尚未授权定位") }

            if (config.runsInApp) { return alertError("尚未授权定位") }
        })

    if (location && Object.keys(location).length) {
        Keychain.set('panda_oil_price', JSON.stringify(location))
    }
    switch (config.widgetFamily) {
        case 'small':
            widget = await renderSmall(location)
            break;

        case 'large':
            widget = await renderLarge(location)
            break;

        default:
            widget = await renderMedium(location)
            break;
    }
    Script.setWidget(widget);
    Script.complete()
}

if (config.runsInApp) {
    let widget
    Location.setAccuracyToHundredMeters()
    const location = await Location.current()
        .catch(async err => {
            if (config.runsInWidget) { widget = await renderError("尚未授权定位") }

            if (config.runsInApp) { return alertError("尚未授权定位") }

        })
    if (location && Object.keys(location).length) {
        Keychain.set('panda_oil_price', JSON.stringify(location))
    }
    widget = await renderMedium(location)
    widget.presentMedium();
    Script.complete()
}

async function renderLarge(location) {

    let r
    if (location) {
        r = new Request(base_api + `lat=${location.latitude}&lng=${location.longitude}`)
    } else {
        let cachedLocation = JSON.parse(Keychain.get('panda_oil_price'))
        r = new Request(base_api + `lat=${cachedLocation.latitude}&lng=${cachedLocation.longitude}`)
    }
    const infos = await r.loadJSON()
    if (infos && infos.price) {
        const _img = await loadImg(img.large)
        const widget = new ListWidget()
        widget.backgroundImage = _img

        const container = widget.addStack()
        container.layoutVertically()


        let tags = ['V0', 'V89', 'V92', 'V95']

        for (let i = 0; i < 5; i++) {
            if (i < 4) {
                const level = container.addStack()
                level.bottomAlignContent()
                level.size = new Size(320, 65)
                const lEmpty = level.addStack()
                lEmpty.size = new Size(90, 65)

                const lImage = level.addStack()
                lImage.size = new Size(150, 65)
                lImage.bottomAlignContent()
                let pricies = []
                for (const vo of infos.price) {
                    pricies.push(vo[tags[i]])
                }
                lImage.backgroundImage = await loadImg(`https://quickchart.io/chart/render/zm-7ea8a883-3a41-4dcf-ac15-b5b13e4d8978?data1=${pricies.join(",")}`)

                const lText = level.addStack()
                lText.size = new Size(80, 65)
                lText.bottomAlignContent()
                const lSymbol = lText.addText("¥")
                lSymbol.textColor = Color.white()
                const lNumber = lText.addText(`${infos.price[0][tags[i]].toFixed(2)}`)
                lNumber.textColor = Color.white()
                lNumber.font = Font.boldSystemFont(30)
            } else {
                const level = container.addStack()
                level.topAlignContent()
                level.size = new Size(320, 65)
                if (infos.statetions && infos.statetions.length) {
                    let times = infos.statetions.length < 3 ? infos.statetions.length : 3
                    for (let i = 0; i < times; i++) {
                        const statetion = level.addStack()
                        statetion.size = new Size(95, 65)
                        statetion.layoutVertically()
                        statetion.topAlignContent()
                        const title = statetion.addText(infos.statetions[i].name)
                        title.textColor = Color.white()
                        title.font = Font.systemFont(12)
                        const tel = statetion.addText(infos.statetions[i].telephone||'')
                        tel.textColor = Color.white()
                        tel.font = Font.systemFont(12)
                        statetion.url = `https://maps.apple.com/?daddr=${encodeURIComponent(infos.statetions[i].name)}2C%20${encodeURIComponent(infos.statetions[i].address)}&saddr=${encodeURIComponent(infos.location.street_number)}2C%20${encodeURIComponent(infos.location.formatted_address)}`
                        if (i !== times) {
                            level.addSpacer(10)
                        }
                    }
                } else {
                    level.centerAlignContent()
                    const text = level.addText("附近未找到加油站")
                    text.textColor = Color.white()
                    text.font = Font.boldSystemFont(40)
                }
            }
        }
        return widget
    } else {
        if (config.runsInWidget) { return renderError("获取数据失败") }

        if (config.runsInApp) { return alertError("获取数据失败") }
    }
}

async function renderMedium(location) {

    let r
    if (location) {
        r = new Request(base_api + `lat=${location.latitude}&lng=${location.longitude}`)
    } else {
        let cachedLocation = JSON.parse(Keychain.get('panda_oil_price'))
        r = new Request(base_api + `lat=${cachedLocation.latitude}&lng=${cachedLocation.longitude}`)
    }
    const infos = await r.loadJSON()
    if (infos && infos.price) {
        const _img = await loadImg(img.medium)
        const widget = new ListWidget()
        widget.backgroundImage = _img

        const container = widget.addStack()

        const left = container.addStack()
        left.size = new Size(200, 140)
        left.layoutVertically()
        const l1 = left.addStack()
        const l1l = l1.addStack()
        const l1r = l1.addStack()
        l1l.bottomAlignContent()
        l1r.bottomAlignContent()
        l1l.size = new Size(100, 60)
        l1r.size = new Size(100, 60)

        const l1lSymbol = l1l.addText("¥")
        l1lSymbol.textColor = Color.white()

        const l1lNumber = l1l.addText(`${infos.price[0]['V0'].toFixed(2)}`)
        l1lNumber.textColor = Color.white()
        l1lNumber.font = Font.boldSystemFont(25)

        const l1rSymbol = l1r.addText("¥")
        l1rSymbol.textColor = Color.white()

        const l1rNumber = l1r.addText(`${infos.price[0]['V89'].toFixed(2)}`)
        l1rNumber.textColor = Color.white()
        l1rNumber.font = Font.boldSystemFont(25)


        const l2 = left.addStack()
        const l2l = l2.addStack()
        const l2r = l2.addStack()
        l2l.bottomAlignContent()
        l2r.bottomAlignContent()
        l2l.size = new Size(100, 80)
        l2r.size = new Size(100, 80)

        const l2lSymbol = l2l.addText("¥")
        l2lSymbol.textColor = Color.white()

        const l2lNumber = l2l.addText(`${infos.price[0]['V92'].toFixed(2)}`)
        l2lNumber.textColor = Color.white()
        l2lNumber.font = Font.boldSystemFont(25)

        const l2rSymbol = l2r.addText("¥")
        l2rSymbol.textColor = Color.white()

        const l2rNumber = l2r.addText(`${infos.price[0]['V95'].toFixed(2)}`)
        l2rNumber.textColor = Color.white()
        l2rNumber.font = Font.boldSystemFont(25)


        const right = container.addStack()
        right.size = new Size(120, 0)
        right.layoutVertically()

        if (infos.statetions && infos.statetions.length) {
            right.topAlignContent()
            let times = infos.statetions.length < 3 ? infos.statetions.length : 3
            for (let i = 0; i < times; i++) {
                const t = right.addStack()
                t.layoutVertically()
                const title = t.addText(infos.statetions[i].name)
                title.textColor = Color.white()
                title.font = Font.systemFont(12)
                const tel = t.addText(infos.statetions[i].telephone||'')
                tel.textColor = Color.white()
                tel.font = Font.systemFont(12)
                t.url = `https://maps.apple.com/?daddr=${encodeURIComponent(infos.statetions[i].name)}2C%20${encodeURIComponent(infos.statetions[i].address)}&saddr=${encodeURIComponent(infos.location.street_number)}2C%20${encodeURIComponent(infos.location.formatted_address)}`
                right.addSpacer(8)

            }
        } else {

            right.centerAlignContent()
            right.textColor = Color.white()
            right.addText("附近未找到加油站")
        }


        return widget
    } else {
        if (config.runsInWidget) { return renderError("获取数据失败") }

        if (config.runsInApp) { return alertError("获取数据失败") }
    }
}

async function renderSmall(location) {
    const number = args.widgetParameter || "95"
    let r
    if (location) {
        r = new Request(base_api + `lat=${location.latitude}&lng=${location.longitude}`)
    } else {
        let cachedLocation = JSON.parse(Keychain.get('panda_oil_price'))
        r = new Request(base_api + `lat=${cachedLocation.latitude}&lng=${cachedLocation.longitude}`)
    }
    const infos = await r.loadJSON()
    if (infos && infos.price) {
        const _img = await loadImg(img[number])
        const view = new ListWidget()
        view.backgroundImage = _img
        const priceArea = view.addStack()
        priceArea.bottomAlignContent()
        priceArea.setPadding(50, 0, 0, 0)
        const proceSymbo = priceArea.addText("¥")
        proceSymbo.font = Font.systemFont(25)
        proceSymbo.textColor = Color.white()
        const priceText = priceArea.addText(`${infos.price[0][`V${number}`].toFixed(2)}`)
        priceText.font = Font.boldSystemFont(45)
        priceText.textColor = Color.white()
        if (infos.statetions && infos.statetions.length) {
            view.url = `https://maps.apple.com/?daddr=${encodeURIComponent(infos.statetions[0].name)}2C%20${encodeURIComponent(infos.statetions[0].address)}&saddr=${encodeURIComponent(infos.location.street_number)}2C%20${encodeURIComponent(infos.location.formatted_address)}`
        }
        return view
    } else {
        if (config.runsInWidget) { return renderError("获取数据失败") }

        if (config.runsInApp) { return alertError("获取数据失败") }
    }
}
async function loadImg(url) {
    const r = new Request(url)
    return await r.loadImage()
}
async function alertError(message) {
    const alert = new Alert()
    alert.title = "有点儿意外发生"
    alert.message = message
    await alert.presentAlert()
    Script.complete()
}

function renderError(message) {
    const view = new ListWidget()
    const msg = view.addText(message)
    msg.centerAlignText()
    msg.textColor = Color.red()
    return view
}