// Variables used by Scriptable.
// These must be at the very top of the file. Do not edit.
// icon-color: blue; icon-glyph: feather-alt;
/*
// 抖音搜索：大舅哥科技
// 微信搜索公众号「大舅哥科技」
// 获取更多精美实用 iOS 桌面组件！
// 更多精选快捷指令、壁纸，等你！
// ***************************
// 环境框架   ：@ DmYY  
// author 	 ：原作者2Ya 由DJG修改
*/

const { DJG, Runing } = importModule(
	FileManager.local().joinPath(
		FileManager.local().libraryDirectory(),
		"/DJG.js"
	)
);

// @组件代码开始
class Widget extends DJG {
	constructor(arg) {
		super(arg);
		this.name = '百度热榜'
		this.widget_ID = "DJG-111"
		this.version = "V3.7"
		this.logo = 'https://www.baidu.com/cache/icon/favicon.ico'

		this.Run(module.filename, args);
	}

	/**
	 * 渲染函数，函数名固定
	 * 可以根据 this.widgetFamily 来判断小组件尺寸，以返回不同大小的内容
	 */
	async render() {
		let widget = this.getWidget();
		await this.getWidgetBackgroundImage(widget);

		// 设置深色模式背景色
		widget.backgroundColor = new Color("#f6f6f6");
		if (Device.isUsingDarkAppearance()) {
			widget.backgroundColor = new Color("#1e293b");
		}
		try {
			let data = await this.getData()
			switch (this.widgetFamily) {
				case 'small':
					await this.renderSmall(widget, data);
					break;
				case 'medium':
					await this.renderMedium(widget, data);
					break;
				default:
					await this.renderMedium(widget, data, 13);
					break;
			}
		} catch (e) {
			this.ERROR.push({ error: e.toString() });
		}
		return widget;
	}

	// 小组件
	async renderSmall(w, data) {
		await this.renderHeader(w, this.logo, this.name)
		const cell = w.addStack()
		this.addText(cell, '1', 14, { font: 'light', color: '#fe2d46' })
		cell.addSpacer(8);
		let title = data['hotsearch'][0]['pure_title'] || data['hotsearch'][0]['card_title']
		this.addText(cell, title, 13, { font: 'light' })
		w.addSpacer()
		let url = decodeURIComponent(data['hotsearch'][0]['linkurl'])
		url = url.replace("://www.", "://m.")
		let score = data['hotsearch'][0]['heat_score']
		this.addText(w, `      ${score}`, 10, { font: 'light', opacity: 0.8, url: url })
	}

	// 中组件
	async renderMedium(w, data, num = 5) {
		w.addSpacer(5);
		await this.renderHeader(w, this.logo, this.name, 8)
		data['hotsearch'].slice(0, num).map((d, i) => {
			const cell = w.addStack();
			cell.centerAlignContent();
			let col = null;
			if (i === 0) {
				col = '#fe2d46'
			} else if (i === 1) {
				col = '#ff6600'
			} else if (i === 2) {
				col = '#faa90e'
			} else { col = '#9195a3' }
			this.addText(cell, String(i + 1), 13, { font: 'light', color: col, font: 'bold' })
			cell.addSpacer(10)
			let title = d['pure_title'] || d['card_title']
			this.addText(cell, title, 13, { font: 'light', lineLimit: 1 })
			cell.addSpacer()
			let score = d['heat_score']
			this.addText(cell, score, 10, { font: 'light', opacity: 0.8 })
			let url = decodeURIComponent(d['linkurl'])
			url = url.replace("://www.", "://m.")
			cell.url = url
			w.addSpacer(6)
		})
	}

	/**
	 * 获取数据函数，函数名可不固定
	 */
	async getData() {
		const options = {
			headers: {
				'User-Agent': "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.67 Safari/537.36 Edg/87.0.664.55"
			}
		}
		let data = await this.httpGet("https://www.baidu.com/", false, true, options)
		const tmp = data.split(`<textarea id="hotsearch_data" style="display:none;">`)[1].split(`</textarea>`)[0]
		data = eval(`(${tmp})`);
		return data
	}

	actionUrl(name = '', data = '') {
		let u = URLScheme.forRunningScript()
		let q = `act=${encodeURIComponent(name)}&data=${encodeURIComponent(data)}&__arg=${encodeURIComponent(this.arg)}&__size=${this.widgetFamily}`
		let result = ''
		if (u.includes('run?')) {
			result = `${u}&${q}`
		} else {
			result = `${u}?${q}`
		}
		return result
	}

	// 添加设置信息
	Run(filename, args) {
		if (config.runsInApp) {
			this.registerAction("基础设置", this.setWidgetConfig);
		}
	}
}

// @组件代码结束
await Runing(Widget)