-- ============================================================================
-- 简单的 TailwindCSS 补全插件（不依赖 LSP）
-- ============================================================================

return {
  -- TailwindCSS IntelliSense（最可靠的补全插件）
  {
    "luckasRanarison/tailwind-tools.nvim",
    dependencies = { 
      "nvim-treesitter/nvim-treesitter",
      "nvim-lua/plenary.nvim"
    },
    opts = {
      document_color = {
        enabled = true, -- 启用颜色显示
        kind = "foreground", -- 显示方式
        inline_symbol = "󰝤 ", -- 颜色符号
        debounce = 200, -- 防抖延迟
      },
      conceal = {
        enabled = false, -- 不隐藏长类名
      },
    },
    config = function(_, opts)
      require("tailwind-tools").setup(opts)
    end,
  },

  -- TailwindCSS 类名补全和颜色显示
  {
    "NvChad/nvim-colorizer.lua",
    config = function()
      require("colorizer").setup({
        user_default_options = {
          tailwind = true, -- 启用 TailwindCSS 颜色识别
          css = true,
          css_fn = true,
          mode = "background", -- 背景色显示
          virtualtext = "■", -- 虚拟文本符号
        },
      })
    end,
  },

  -- 替代 LSP 的 TailwindCSS 补全源
  {
    "js-everts/cmp-tailwind-colors",
    config = function()
      -- 为 nvim-cmp 添加 TailwindCSS 颜色补全
      local cmp = require("cmp")
      local config = cmp.get_config()
      
      -- 添加 TailwindCSS 补全源到 HTML 相关文件
      for _, filetype in ipairs({"html", "htm", "css", "scss", "vue", "jsx", "tsx"}) do
        cmp.setup.filetype(filetype, {
          sources = cmp.config.sources(vim.list_extend(config.sources or {}, {
            { name = "tailwind-colors" },
          }))
        })
      end
    end,
  },
}