-- ============================================================================
-- 键位映射配置文件 (mappings.lua)
-- 定义自定义的键位映射和快捷键
-- 注意：此文件当前为空，主要的键位映射配置在 configs/mappings.lua 中
-- ============================================================================

-- ============================================================================
-- 使用说明
-- ============================================================================
-- 此文件是 NvChad 框架中的用户自定义键位映射文件
-- 主要的键位映射配置位于 configs/mappings.lua
-- 如果需要添加额外的键位映射，可以在此文件中定义
--
-- 键位映射格式：
-- vim.keymap.set("模式", "按键", "命令", { 选项 })
--
-- 示例：
-- vim.keymap.set("n", "<C-s>", ":w<CR>", { desc = "保存文件" })
-- vim.keymap.set("i", "<C-c>", "<ESC>", { desc = "退出插入模式" })
--
-- 模式说明：
-- "n" = 普通模式 (Normal mode)
-- "i" = 插入模式 (Insert mode)
-- "v" = 可视模式 (Visual mode)
-- "x" = 可视块模式 (Visual block mode)
-- "t" = 终端模式 (Terminal mode)
-- "c" = 命令行模式 (Command mode)
-- ============================================================================

-- 在这里添加你的额外键位映射
-- 例如：
-- vim.keymap.set("n", "<leader>test", function()
--   print("测试键位映射")
-- end, { desc = "测试功能" })

-- 注意：避免与 configs/mappings.lua 中的键位映射冲突

