-- ============================================================================
-- Lazy.nvim 界面颜色配置文件 (lazy-colors.lua)
-- 专门用于配置 Lazy.nvim 插件管理器界面的颜色和样式
-- ============================================================================

local M = {}

-- ============================================================================
-- 1. Lazy 界面颜色设置函数
-- ============================================================================
function M.setup_lazy_colors()
	-- 设置 Lazy 界面的高亮组，提高可见性和对比度

	-- 基础界面颜色
	vim.cmd("highlight! LazyNormal guifg=#ffffff guibg=#1a1a1a gui=NONE")
	vim.cmd("highlight! LazyComment guifg=#888888 gui=NONE")
	vim.cmd("highlight! LazyDimmed guifg=#666666 gui=NONE")

	-- 标题和标头
	vim.cmd("highlight! LazyH1 guifg=#ffffff guibg=#333333 gui=bold")
	vim.cmd("highlight! LazyH2 guifg=#ffff00 gui=bold")

	-- 提交信息相关
	vim.cmd("highlight! LazyCommit guifg=#ffff00 gui=NONE")
	vim.cmd("highlight! LazyCommitIssue guifg=#ff6666 gui=NONE")
	vim.cmd("highlight! LazyCommitScope guifg=#66ff66 gui=NONE")
	vim.cmd("highlight! LazyCommitType guifg=#6666ff gui=NONE")

	-- 目录和文件
	vim.cmd("highlight! LazyDir guifg=#66ffff gui=NONE")
	vim.cmd("highlight! LazyLocal guifg=#ff9900 gui=NONE")

	-- 进度指示器
	vim.cmd("highlight! LazyProgressDone guifg=#00ff00 gui=NONE")
	vim.cmd("highlight! LazyProgressTodo guifg=#666666 gui=NONE")

	-- 属性和值
	vim.cmd("highlight! LazyProp guifg=#99ccff gui=NONE")
	vim.cmd("highlight! LazyValue guifg=#99ff99 gui=NONE")

	-- 原因标签（不同颜色区分不同类型）
	vim.cmd("highlight! LazyReasonCmd guifg=#ffcc99 gui=NONE")
	vim.cmd("highlight! LazyReasonEvent guifg=#ccffcc gui=NONE")
	vim.cmd("highlight! LazyReasonFt guifg=#ffccff gui=NONE")
	vim.cmd("highlight! LazyReasonImport guifg=#ccccff gui=NONE")
	vim.cmd("highlight! LazyReasonKeys guifg=#ffffcc gui=NONE")
	vim.cmd("highlight! LazyReasonPlugin guifg=#ffcccc gui=NONE")
	vim.cmd("highlight! LazyReasonRuntime guifg=#ccffff gui=NONE")
	vim.cmd("highlight! LazyReasonSource guifg=#ffffff gui=NONE")
	vim.cmd("highlight! LazyReasonStart guifg=#00ffff gui=NONE")

	-- 特殊元素
	vim.cmd("highlight! LazySpecial guifg=#ff00ff gui=NONE")
	vim.cmd("highlight! LazyUrl guifg=#0099ff gui=underline")

	-- 任务和输出
	vim.cmd("highlight! LazyTaskError guifg=#ff0000 gui=bold")
	vim.cmd("highlight! LazyTaskOutput guifg=#cccccc gui=NONE")

	-- 按钮和交互元素（英文按键字符使用亮蓝色）
	vim.cmd("highlight! LazyButton guifg=#66ccff guibg=#444444 gui=NONE")
	vim.cmd("highlight! LazyButtonActive guifg=#66ccff guibg=#333333 gui=bold")

	-- 按键提示相关（英文字符亮蓝色）
	vim.cmd("highlight! LazyKey guifg=#66ccff gui=bold")
	vim.cmd("highlight! LazyKeyPlugin guifg=#66ccff gui=NONE")

	-- 浮动窗口背景
	vim.cmd("highlight! LazyBackdrop guibg=#000000 gui=NONE")

	-- 边框和分隔符
	vim.cmd("highlight! LazyFloatBorder guifg=#666666 guibg=#1a1a1a gui=NONE")
	vim.cmd("highlight! LazyFloatTitle guifg=#ffffff guibg=#333333 gui=bold")
end

-- ============================================================================
-- 2. 自动应用颜色设置
-- ============================================================================
function M.setup()
	-- 创建自动命令，在适当的时机应用 Lazy 颜色
	vim.api.nvim_create_autocmd({ "VimEnter", "ColorScheme" }, {
		callback = function()
			-- 延迟执行，确保主题完全加载
			vim.defer_fn(function()
				M.setup_lazy_colors()
			end, 100)
		end,
		desc = "应用 Lazy.nvim 界面颜色配置",
	})

	-- 当打开 Lazy 界面时强制应用颜色
	vim.api.nvim_create_autocmd("User", {
		pattern = "LazyVimStarted",
		callback = function()
			M.setup_lazy_colors()
		end,
		desc = "Lazy 启动后应用颜色配置",
	})
end

return M
