# NvimTree 快捷键指南

## 🔧 自定义标记批量操作命令

**重要说明：** 由于键盘映射冲突，标记相关的批量操作已改为编辑器命令形式。

## 🎯 批量操作命令

### 📋 单文件操作（按优先级排序）
- `:NvimTreeA1Copy` - 复制当前文件/目录
- `:NvimTreeA2Cut` - 剪切当前文件/目录
- `:NvimTreeA3Paste` - 粘贴文件/目录
- `:NvimTreeA7ClearClipboard` - 清空剪贴板

### 📁 批量操作（按优先级排序）
- `:NvimTreeA1MarkCopy` - 批量复制标记的文件
- `:NvimTreeA2MarkCut` - 批量剪切标记的文件
- `:NvimTreeA4MarkMove` - 批量移动标记的文件（自动创建目录）
- `:NvimTreeA5Rename` - 重命名当前文件/目录
- `:NvimTreeA6MarkDelete` - 批量删除标记的文件
- `:NvimTreeA6MarkTrash` - 批量移动标记的文件到垃圾箱
- `:NvimTreeA7Clear` - 清除所有标记
- `:NvimTreeA8MarkNext` - 跳转到下一个标记的文件
- `:NvimTreeA8MarkPrev` - 跳转到上一个标记的文件

### 🔧 系统命令（排序优化）
- `:ZCheatsheet` - 打开 NvChad 快捷键帮助
- `:ZDash` - 打开 NvChad 启动页面

**命令排序说明：**
- 自定义NvimTree命令使用 `A[数字]` 前缀，按功能类型分组
- 系统命令使用 `Z` 前缀确保排在其他命令后面
- 相同类型的命令共享相同数字（如A1用于复制，A2用于剪切）

## ✨ 自动创建目录功能

### 单文件移动（快捷键 `tm`）
- 选中文件后按 `tm`
- 输入目标路径（可以是完整的文件路径）
- 如果目标目录不存在，会自动创建
- 支持多级目录创建（如：`new/folder/subfolder/file.txt`）

### 批量文件移动（命令 `:NvimTreeMarkMove`）
- 先用 `m` 标记多个文件
- 执行 `:NvimTreeMarkMove` 命令
- 输入目标目录路径
- 如果目标目录不存在，会自动创建
- 所有标记的文件会移动到目标目录

### 使用示例
```
# 移动文件到新目录
1. 选中文件，按 tm
2. 输入：/path/to/new/directory/filename.txt
3. 系统会自动创建 /path/to/new/directory/ 目录
4. 文件移动完成

# 批量移动到新目录
1. 用 m 标记多个文件
2. 执行 :NvimTreeMarkMove
3. 输入：/path/to/target/directory/
4. 系统会自动创建目标目录并移动所有文件

# 单文件复制粘贴
1. 选中文件，按 yy 复制（或使用 :NvimTreeCopy 命令）
2. 导航到目标目录
3. 按 p 粘贴文件（或使用 :NvimTreePaste 命令）
4. 如需清空剪贴板，按 cc

# 单文件剪切粘贴
1. 选中文件，按 x 剪切（或使用 :NvimTreeCut 命令）
2. 导航到目标目录
3. 按 p 粘贴文件（或使用 :NvimTreePaste 命令）

# 批量复制文件
**重要提醒**：批量复制粘贴需要按正确顺序执行，缺少任何一步都会导致操作失败！
1. 第1步：用 m 标记多个文件
2. 第2步：执行 :NvimTreeA1MarkCopy 复制所有标记的文件到剪贴板
3. 第3步：导航到目标目录
4. 第4步：按 p 粘贴所有文件（或使用 :NvimTreeA3Paste 命令）

# 批量剪切文件
1. 第1步：用 m 标记多个文件
2. 第2步：执行 :NvimTreeA2MarkCut 剪切所有标记的文件到剪贴板
3. 第3步：导航到目标目录
4. 第4步：按 p 粘贴所有文件（或使用 :NvimTreeA3Paste 命令）

**重要说明**：
- 快捷键 `yy` 和 `x` 现在只对当前选中的单个文件生效
- 批量操作必须使用专门的命令 `:NvimTreeA1MarkCopy` 和 `:NvimTreeA2MarkCut`
- 这样设计是为了避免误操作，让单文件和批量操作有明确的区分

**常见错误**：直接执行粘贴而跳过复制/剪切步骤，这样剪贴板是空的，粘贴不会有任何效果。
```

### 📝 使用步骤
1. 使用 `m` 键标记需要操作的文件（可标记多个）
2. 输入相应的命令执行批量操作
3. 示例：先用 `m` 标记几个文件，然后输入 `:NvimTreeA6MarkDelete` 批量删除

---

## 📁 NvimTree 默认快捷键分类指南

### 🔍 文件和目录操作
| 快捷键 | 功能描述 |
|--------|----------|
| `<CR>` 或 `o` | 打开文件或展开/折叠目录 |
| `<Tab>` | 预览文件（不切换焦点到文件） |
| `a` | 创建新文件或目录（路径以 `/` 结尾创建目录） |
| `d` | 删除选中的文件或目录 |
| `r` | 重命名文件或目录 |
| `x` | 剪切文件或目录到剪贴板 |
| `c` | 复制文件或目录到剪贴板 |
| `p` | 粘贴剪贴板中的文件或目录 |
| `s` | 使用系统默认程序打开文件 |

### 📋 复制路径操作
| 快捷键 | 功能描述 |
|--------|----------|
| `y` | 复制文件名到剪贴板 |
| `Y` | 复制文件相对路径到剪贴板 |
| `gy` | 复制文件绝对路径到剪贴板 |

### 🧭 导航和跳转
| 快捷键 | 功能描述 |
|--------|----------|
| `<C-]>` | 进入选中的目录 |
| `<BS>` 或 `<C-h>` | 返回上级目录 |
| `P` | 跳转到当前节点的父节点 |
| `<C-k>` | 跳转到第一个兄弟节点 |
| `<C-j>` | 跳转到最后一个兄弟节点 |
| `K` | 跳转到上一个兄弟节点 |
| `J` | 跳转到下一个兄弟节点 |

### 🪟 窗口和视图控制
| 快捷键 | 功能描述 |
|--------|----------|
| `<C-x>` | 在水平分割窗口中打开文件 |
| `<C-v>` | 在垂直分割窗口中打开文件 |
| `<C-t>` | 在新标签页中打开文件 |
| `W` | 折叠所有展开的目录 |
| `E` | 展开所有目录 |
| `<C-r>` | 刷新整个文件树 |
| `R` | 刷新当前目录 |

### 🔍 搜索和过滤
| 快捷键 | 功能描述 |
|--------|----------|
| `<C-f>` | 启用实时文件过滤 |
| `F` | 清除当前的文件过滤器 |
| `<C-s>` | 搜索文件节点 |
| `f` | 查找文件（实时搜索） |

### 👁️ 显示控制
| 快捷键 | 功能描述 |
|--------|----------|
| `I` | 切换 gitignore 文件显示 |
| `H` | 切换隐藏文件（点文件）显示 |
| `U` | 切换自定义隐藏文件显示 |

### 🏷️ 标记操作
| 快捷键 | 功能描述 |
|--------|----------|
| `m` | 标记/取消标记文件（用于批量操作） |

## 📁 批量操作快捷键

| 快捷键 | 功能 | 说明 |
|--------|------|------|
| `m` | 标记/取消标记文件 | 切换当前文件的标记状态 |
| `td` | 批量删除标记的文件 | 永久删除所有标记的文件 |
| `tt` | 批量移动到垃圾箱 | 将标记的文件移动到系统垃圾箱 |
| `tm` | 移动文件（使用系统命令） | 移动当前文件，如果目标目录不存在会自动创建 |
| `tc` | 清除所有标记 | 取消所有文件的标记状态 |
| `mn` | 跳转到下一个标记 | 光标移动到下一个标记的文件 |
| `mp` | 跳转到上一个标记 | 光标移动到上一个标记的文件 |

## 📋 复制粘贴快捷键

| 快捷键 | 功能 | 说明 |
|--------|------|------|
| `yy` | 复制文件/目录 | 将当前文件或目录复制到nvim-tree剪贴板 |
| `x` | 剪切文件/目录 | 将当前文件或目录剪切到nvim-tree剪贴板 |
| `p` | 粘贴文件/目录 | 将剪贴板中的文件或目录粘贴到当前位置 |
| `cc` | 清空剪贴板 | 清空nvim-tree剪贴板中的内容 |

### ❓ 帮助和其他
| 快捷键 | 功能描述 |
|--------|----------|
| `g?` | 显示完整的帮助信息 |
| `q` | 关闭 NvimTree 窗口 |
| `<C-e>` | 编辑文件树的根目录路径 |

---

## 💡 使用技巧

1. **批量操作流程：** 使用 `m` 标记多个文件 → 执行批量命令
2. **快速导航：** 使用 `P` 快速回到父目录，`<C-]>` 快速进入目录
3. **多窗口操作：** 使用 `<C-v>` 和 `<C-x>` 在分割窗口中打开文件
4. **文件过滤：** 使用 `<C-f>` 快速过滤大目录中的文件
5. **路径复制：** 根据需要选择 `y`（文件名）、`Y`（相对路径）或 `gy`（绝对路径）

---
*按 `q` 或 `<Esc>` 关闭此帮助窗口*