-- ============================================================================
-- nvim-cmp 彩色图标配置
-- ============================================================================

local M = {}

-- 更好的等宽图标配置 (基于 Ben Frain 的建议)
M.kind_icons = {
	Text = "",
	Method = "", 
	Function = "",
	Constructor = "",
	Field = "",
	Variable = "",
	Class = "",
	Interface = "",
	Module = "",
	Property = "",
	Unit = "",
	Value = "",
	Enum = "",
	Keyword = "",
	Snippet = "",
	Color = "",
	File = "",
	Reference = "",
	Folder = "",
	EnumMember = "",
	Constant = "",
	Struct = "",
	Event = "",
	Operator = "",
	TypeParameter = "",
	Table = "",
	Object = "",
	Tag = "",
	Array = "",
	Boolean = "",
	Number = "",
	String = "",
	Null = "",
	-- AI 补全来源 (使用 Nerd Font 图标以确保等宽)
	Supermaven = "",
	Copilot = "", 
	Codeium = "",
	TabNine = "",
}

-- 覆盖 NvChad 的图标
function M.setup()
	-- 直接修改 package.loaded 中的模块
	local nvchad_icons = require("nvchad.icons.lspkind")
	
	-- 直接覆盖图标
	for kind, icon in pairs(M.kind_icons) do
		nvchad_icons[kind] = icon
	end
	
	-- 强制重新加载
	package.loaded["nvchad.icons.lspkind"] = nvchad_icons
end

return M