# GitSigns.nvim 使用指南

GitSigns 是一个强大的 Git 集成插件，为 Neovim 提供了丰富的 Git 功能。它在编辑器左侧显示 Git 变更标志，并提供了一系列 Git 操作命令。

## 🎯 主要功能

### 1. 可视化 Git 状态
- **新增行**: `┃` (绿色) - 显示新添加的代码行
- **修改行**: `┃` (橙色) - 显示已修改的代码行  
- **删除行**: `_` (红色) - 显示已删除的行位置
- **未跟踪文件**: `┆` (灰色) - 显示未被 Git 跟踪的文件

### 2. Hunk 导航
"Hunk" 是指一组连续的变更行。

**快捷键:**
- `]c` - 跳转到下一个 hunk
- `[c` - 跳转到上一个 hunk

### 3. 暂存操作 (Staging)

**单个 Hunk 操作:**
- `<leader>gs` - 暂存当前 hunk (将变更添加到暂存区)
- `<leader>gr` - 重置当前 hunk (撤销变更)
- `<leader>gu` - 撤销暂存 hunk (从暂存区移除)

**可视模式下的选择性操作:**
1. 使用 `v` 进入可视模式，选择你想要操作的行
2. `<leader>gs` - 暂存选中的行
3. `<leader>gr` - 重置选中的行

**整个文件操作:**
- `<leader>gS` - 暂存整个文件的所有变更
- `<leader>gR` - 重置整个文件的所有变更

### 4. 查看和预览

**预览变更:**
- `<leader>gp` - 在浮动窗口中预览当前 hunk 的变更

**Blame 信息 (查看代码作者):**
- `<leader>gb` - 查看当前行的详细 blame 信息
- `<leader>gB` - 切换当前行 blame 信息的实时显示

**Diff 查看:**
- `<leader>gd` - 查看当前文件的 diff
- `<leader>gD` - 查看文件与上次提交的 diff

### 5. 显示控制

- `<leader>gt` - 切换显示已删除行的标记
- `<leader>gw` - 切换单词级别的 diff 显示

## 🚀 实用工作流程

### 场景1: 代码审查工作流
1. 使用 `]c` 和 `[c` 在 hunk 之间导航
2. 使用 `<leader>gp` 预览每个 hunk 的变更
3. 使用 `<leader>gb` 查看修改的历史信息
4. 决定是否暂存：`<leader>gs` 或重置：`<leader>gr`

### 场景2: 选择性提交
1. 使用 `<leader>gs` 逐个暂存你想要提交的 hunk
2. 或者在可视模式下选择特定行进行暂存
3. 使用 `<leader>gu` 撤销错误的暂存操作
4. 最后使用 Git 命令提交暂存的变更

### 场景3: 快速修复
1. 使用 `<leader>gd` 查看所有变更
2. 使用 `<leader>gr` 快速重置不需要的变更
3. 使用 `<leader>gS` 暂存所有剩余的变更

## 💡 使用技巧

### 1. 与 Which-Key 集成
按 `<leader>g` 会显示所有 Git 相关的快捷键菜单，方便记忆和查找。

### 2. 颜色标识
- **绿色标志**: 新增的代码，通常是好的变更
- **橙色标志**: 修改的代码，需要仔细检查
- **红色标志**: 删除的代码位置，确认是否需要

### 3. 键位记忆法
- `s` = Stage (暂存)
- `r` = Reset (重置) 
- `u` = Undo (撤销)
- `p` = Preview (预览)
- `b` = Blame (责任信息)
- `d` = Diff (差异)

### 4. 文本对象
在操作符（如 `d`、`y`、`c`）后使用 `ih` 来选择当前 hunk：
- `dih` - 删除当前 hunk
- `yih` - 复制当前 hunk
- `cih` - 修改当前 hunk

## 🔧 配置特性

### 自动附加
插件会自动检测 Git 仓库并附加到文件，无需手动激活。

### 性能优化
- 延迟加载，仅在打开文件时激活
- 智能文件监控，实时更新变更标志

### 自定义高亮
配置了特定的颜色方案：
- 新增: 绿色 (#98be65)
- 修改: 橙色 (#ECBE7B) 
- 删除: 红色 (#ec5f67)
- 未跟踪: 灰色 (#5c6370)

## 📚 进阶用法

### 1. 命令模式
除了快捷键，你也可以使用命令：
- `:Gitsigns stage_hunk` - 暂存 hunk
- `:Gitsigns reset_hunk` - 重置 hunk
- `:Gitsigns preview_hunk` - 预览 hunk

### 2. 与其他插件协作
GitSigns 与 NvChad 的其他组件无缝集成：
- 与 Telescope 配合进行 Git 文件搜索
- 与状态栏显示 Git 状态信息
- 与文件树显示 Git 文件状态

### 3. 批量操作
使用可视块模式（`<C-v>`）选择多行，然后使用 GitSigns 命令进行批量操作。

## ❗ 注意事项

1. **Git 仓库要求**: GitSigns 只在 Git 仓库中工作
2. **文件保存**: 某些操作需要文件已保存才能正确显示
3. **网络操作**: blame 功能可能需要网络连接来获取完整信息
4. **性能考虑**: 在非常大的文件中，diff 操作可能会稍慢

## 🆘 故障排除

### GitSigns 不显示标志
1. 检查是否在 Git 仓库中：`:!git status`
2. 检查插件是否加载：`:GitSigns`
3. 重新加载配置：`:source $MYVIMRC`

### 快捷键不工作
1. 检查 Which-Key：`<leader>g`
2. 查看键位映射：`:verbose map <leader>gs`
3. 检查插件依赖：`:checkhealth gitsigns`

---

现在你已经安装并配置好了 GitSigns.nvim，可以在任何 Git 仓库中享受强大的 Git 集成功能！记住多使用 `<leader>g` 来查看可用的命令。