/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    // 支持所有常见的前端文件格式
    "**/*.{html,htm,js,ts,jsx,tsx,vue,svelte,astro,php,twig,md}",
    // 支持模板文件
    "**/*.{django,jinja,liquid,mustache,handlebars}",
    // 支持样式文件
    "**/*.{css,scss,sass,less,postcss}",
    // 支持配置文件
    "**/*.{json,yaml,yml}"
  ],
  theme: {
    extend: {
      // 常用的扩展配置
      colors: {
        primary: {
          50: '#eff6ff',
          100: '#dbeafe',
          200: '#bfdbfe',
          300: '#93c5fd',
          400: '#60a5fa',
          500: '#3b82f6',
          600: '#2563eb',
          700: '#1d4ed8',
          800: '#1e40af',
          900: '#1e3a8a',
          950: '#172554',
        }
      },
      fontFamily: {
        sans: ['Inter', 'ui-sans-serif', 'system-ui', '-apple-system', 'BlinkMacSystemFont', 'Segoe UI', 'Roboto', 'Helvetica Neue', 'Arial', 'Noto Sans', 'sans-serif'],
        mono: ['JetBrains Mono', 'ui-monospace', 'SFMono-Regular', 'Monaco', 'Consolas', 'Liberation Mono', 'Menlo', 'monospace'],
      },
      spacing: {
        '18': '4.5rem',
        '88': '22rem',
        '128': '32rem',
      },
      animation: {
        'fade-in': 'fadeIn 0.5s ease-in-out',
        'slide-up': 'slideUp 0.3s ease-out',
        'bounce-slow': 'bounce 2s infinite',
      },
      keyframes: {
        fadeIn: {
          '0%': { opacity: '0' },
          '100%': { opacity: '1' },
        },
        slideUp: {
          '0%': { transform: 'translateY(10px)', opacity: '0' },
          '100%': { transform: 'translateY(0)', opacity: '1' },
        },
      },
    },
  },
  plugins: [
    // 常用插件的配置示例（需要安装对应的插件）
    // require('@tailwindcss/forms'),
    // require('@tailwindcss/typography'),
    // require('@tailwindcss/aspect-ratio'),
    // require('@tailwindcss/container-queries'),
  ],
  // 开发模式配置
  safelist: [
    // 确保这些类永远不会被purge
    'bg-red-500',
    'text-3xl',
    'lg:text-4xl',
  ],
}