# NvimTree 通配符模式匹配功能使用指南

## 功能概述

NvimTree 现在支持基于 `.gitignore` 文件的通配符模式匹配，可以自动将匹配的文件和目录显示为浅灰色。

## 支持的通配符

### 基本通配符
- `*` - 匹配任意数量的字符（包括零个字符）
- `?` - 匹配单个字符

### 示例模式
- `*.txt` - 匹配所有 .txt 文件
- `*.log` - 匹配所有 .log 文件
- `temp*` - 匹配所有以 temp 开头的文件
- `*.tmp` - 匹配所有以 .tmp 结尾的文件
- `test?.md` - 匹配 test1.md, test2.md 等文件
- `src/*.js` - 匹配 src 目录下的所有 .js 文件

## 使用方法

### 1. 在 .gitignore 文件中添加模式
```gitignore
# 忽略所有 .txt 文件
*.txt

# 忽略所有 .log 文件
*.log

# 忽略所有以 temp 开头的文件
temp*

# 忽略特定目录
node_modules/
dist/
build/
```

### 2. 自动应用
- 当打开 NvimTree 时，系统会自动读取 `.gitignore` 文件
- 匹配的文件和目录会显示为浅灰色
- 颜色会在文件保存时自动更新

### 3. 手动刷新
如果修改了 `.gitignore` 文件，可以手动刷新颜色：
```vim
:NvimTreeRefreshIgnored
```

## 测试命令

### 测试通配符功能
```vim
:NvimTreeTestWildcard
```
这会启用调试模式并显示匹配过程。

### 测试特定模式
```vim
:NvimTreeTestPattern *.txt
```
这会测试 `*.txt` 模式并显示匹配的文件。

## 技术实现

### 模式匹配算法
1. 读取 `.gitignore` 文件中的每一行
2. 过滤掉空行和注释行
3. 将通配符模式转换为 Lua 正则表达式
4. 对每个文件进行模式匹配
5. 为匹配的文件创建语法高亮规则

### 高亮组
- `NvimTreeIgnoredPattern` - 通配符匹配的文件
- `NvimTreeIgnoredPatternForce` - 强制通配符匹配
- `NvimTreeIgnoredFile` - 完全匹配的文件
- `NvimTreeIgnoredDir` - 完全匹配的目录

## 注意事项

1. **性能考虑**: 通配符匹配会增加处理时间，特别是在大型项目中
2. **模式优先级**: 完全匹配优先于通配符匹配
3. **特殊字符**: 模式中的特殊字符会被正确转义
4. **路径分隔符**: 支持包含路径分隔符的模式

## 故障排除

### 模式不匹配
1. 检查 `.gitignore` 文件格式是否正确
2. 使用 `:NvimTreeTestPattern` 命令测试模式
3. 启用调试模式查看匹配过程

### 颜色不更新
1. 执行 `:NvimTreeRefreshIgnored` 命令
2. 重新打开 NvimTree
3. 检查高亮组是否正确设置

## 示例 .gitignore 文件

```gitignore
# 日志文件
*.log
*.out

# 临时文件
*.tmp
*.temp
temp*

# 构建输出
dist/
build/
target/

# 依赖目录
node_modules/
vendor/

# 配置文件
*.config
config.ini

# 特定文件类型
*.bak
*.swp
*.swo

# 混合模式
src/*.js
docs/*.md
tests/*.test.js
```

这个功能让 NvimTree 能够更好地反映项目的实际状态，帮助开发者快速识别被忽略的文件和目录。
