-- ============================================================================
-- 键位映射配置文件 (keymaps.lua)
-- 定义自定义的键位映射和快捷键
-- 注意：此文件当前为空，可根据需要添加自定义键位映射
-- ============================================================================

-- ============================================================================
-- 使用说明
-- ============================================================================
-- 此文件用于定义用户自定义的键位映射
-- 如果需要添加键位映射，可以使用以下格式：
--
-- vim.keymap.set("模式", "按键", "命令", { 选项 })
--
-- 示例：
-- vim.keymap.set("n", "<leader>w", ":w<CR>", { desc = "保存文件" })
-- vim.keymap.set("i", "jk", "<ESC>", { desc = "退出插入模式" })
--
-- 模式说明：
-- "n" = 普通模式 (Normal mode)
-- "i" = 插入模式 (Insert mode)
-- "v" = 可视模式 (Visual mode)
-- "x" = 可视块模式 (Visual block mode)
-- "t" = 终端模式 (Terminal mode)
-- "c" = 命令行模式 (Command mode)
--
-- 注意：主要的键位映射配置在 configs/mappings.lua 中
-- ============================================================================

-- 在这里添加你的自定义键位映射
-- 例如：
-- vim.keymap.set("n", "<leader>hello", function()
--   print("Hello from keymaps.lua!")
-- end, { desc = "打印问候语" })
