-- ============================================================================
-- 完全独立的 nvim-cmp 测试配置
-- ============================================================================

-- 完全重新初始化 nvim-cmp，不使用任何默认配置
local cmp = require("cmp")

-- 清除所有现有配置
cmp.setup({})

-- LSP Kind 图标
local kind_icons = {
	Text = "󰉿",
	Method = "󰆧", 
	Function = "󰊕",
	Constructor = "",
	Field = "󰜢",
	Variable = "󰀫",
	Class = "󰠱",
	Interface = "",
	Module = "",
	Property = "󰜢",
	Unit = "󰑭",
	Value = "󰎠",
	Enum = "",
	Keyword = "󰌋",
	Snippet = "",
	Color = "󰏘",
	File = "󰈙",
	Reference = "󰈇",
	Folder = "󰉋",
	EnumMember = "",
	Constant = "󰏿",
	Struct = "󰙅",
	Event = "",
	Operator = "󰆕",
	TypeParameter = "",
}

-- 完全重新配置
cmp.setup({
	snippet = {
		expand = function(args)
			require("luasnip").lsp_expand(args.body)
		end,
	},
	
	formatting = {
		fields = { "kind", "abbr", "menu" },
		format = function(entry, vim_item)
			-- 调试输出
			print("BEFORE:", vim_item.kind, vim_item.abbr, vim_item.menu)
			
			-- 获取图标
			local icon = kind_icons[vim_item.kind] or "🔵"
			
			-- 方法1: 图标+类型在kind字段
			vim_item.kind = string.format("%s %s", icon, vim_item.kind)
			vim_item.menu = "[TEST]"
			
			print("AFTER:", vim_item.kind, vim_item.abbr, vim_item.menu)
			return vim_item
		end,
	},
	
	mapping = cmp.mapping.preset.insert({
		['<C-Space>'] = cmp.mapping.complete(),
		['<C-e>'] = cmp.mapping.abort(),
		['<CR>'] = cmp.mapping.confirm({ select = true }),
		["<Tab>"] = cmp.mapping.select_next_item(),
		["<S-Tab>"] = cmp.mapping.select_prev_item(),
	}),
	
	sources = cmp.config.sources({
		{ name = "nvim_lsp" },
		{ name = "luasnip" },
		{ name = "buffer" },
	}),
})