-- ============================================================================
-- 简化的 nvim-cmp 配置 (测试用)
-- ============================================================================

local cmp = require("cmp")
local luasnip = require("luasnip")

-- LSP Kind 图标
local kind_icons = {
	Text = "󰉿",
	Method = "󰆧", 
	Function = "󰊕",
	Constructor = "",
	Field = "󰜢",
	Variable = "󰀫",
	Class = "󰠱",
	Interface = "",
	Module = "",
	Property = "󰜢",
	Unit = "󰑭",
	Value = "󰎠",
	Enum = "",
	Keyword = "󰌋",
	Snippet = "",
	Color = "󰏘",
	File = "󰈙",
	Reference = "󰈇",
	Folder = "󰉋",
	EnumMember = "",
	Constant = "󰏿",
	Struct = "󰙅",
	Event = "",
	Operator = "󰆕",
	TypeParameter = "",
}

-- 完全自定义的 nvim-cmp 配置
cmp.setup({
	snippet = {
		expand = function(args)
			luasnip.lsp_expand(args.body)
		end,
	},
	
	-- 成功的配置：使用 menu 字段在左侧显示图标和类型
	formatting = {
		fields = { "menu", "abbr" },
		format = function(entry, vim_item)
			local icon = kind_icons[vim_item.kind] or ""
			local kind_text = vim_item.kind
			
			-- 将图标和类型放到 menu 字段（左侧显示）
			vim_item.menu = string.format("%s %s", icon, kind_text)
			
			-- 清空 kind 字段避免重复显示
			vim_item.kind = ""
			
			return vim_item
		end,
	},
	
	mapping = cmp.mapping.preset.insert({
		['<C-b>'] = cmp.mapping.scroll_docs(-4),
		['<C-f>'] = cmp.mapping.scroll_docs(4),
		['<C-Space>'] = cmp.mapping.complete(),
		['<C-e>'] = cmp.mapping.abort(),
		['<CR>'] = cmp.mapping.confirm({ select = true }),
		["<Tab>"] = cmp.mapping(function(fallback)
			if cmp.visible() then
				cmp.select_next_item()
			elseif luasnip.expand_or_jumpable() then
				luasnip.expand_or_jump()
			else
				fallback()
			end
		end, { "i", "s" }),
		["<S-Tab>"] = cmp.mapping(function(fallback)
			if cmp.visible() then
				cmp.select_prev_item()
			elseif luasnip.jumpable(-1) then
				luasnip.jump(-1)
			else
				fallback()
			end
		end, { "i", "s" }),
	}),
	
	sources = cmp.config.sources({
		{ name = "nvim_lsp" },
		{ name = "luasnip" },
	}, {
		{ name = "buffer" },
		{ name = "async_path" },
	}),
	
	window = {
		completion = cmp.config.window.bordered(),
		documentation = cmp.config.window.bordered(),
	},
})