-- ============================================================================
-- Lazy.nvim 插件管理器配置文件 (lazy.lua)
-- 配置 Lazy.nvim 的行为、UI 界面和性能优化选项
-- ============================================================================

-- ============================================================================
-- 1. 基础配置初始化
-- ============================================================================
return {
	-- ============================================================================
	-- 2. 基础行为设置
	-- ============================================================================

	-- 2.1 默认设置
	defaults = {
		lazy = true -- 默认启用懒加载，提高启动速度
	},

	-- 2.2 安装设置
	install = {
		colorscheme = { "nvchad" } -- 安装插件时使用的默认主题
	},

	-- ============================================================================
	-- 3. 用户界面配置
	-- ============================================================================

	-- 3.1 界面图标和颜色设置
	ui = {
		-- 自定义图标设置
		icons = {
			ft = "", -- 文件类型图标
			lazy = "󰂠 ", -- Lazy.nvim 主图标
			loaded = "", -- 已加载插件图标
			not_loaded = "", -- 未加载插件图标
		},

		-- 自定义颜色主题
		custom_keys = {
			-- 改善 Lazy 界面的可见性
			["<localleader>l"] = false, -- 禁用默认快捷键
		},

		-- 窗口配置
		size = { width = 0.8, height = 0.8 },
		wrap = true, -- 启用文本换行

		-- 边框设置
		border = "rounded",

		-- 标题设置
		title = " 󰂠 Lazy ",
		title_pos = "center",

		-- 界面打开时的回调函数
		backdrop = 60, -- 背景透明度
	},

	-- 添加颜色配置回调
	change_detection = {
		enabled = true,
		notify = false, -- 不显示变更通知，减少干扰
	},

	-- ============================================================================
	-- 4. 性能优化配置
	-- ============================================================================

	-- 4.1 运行时路径优化
	-- 通过禁用不必要的内置插件来优化 Neovim 的启动性能
	-- 这些插件通常不在现代 Neovim 配置中使用，或已被更好的替代方案取代
	performance = {
		rtp = {
			-- 禁用的内置插件列表（按功能分类）
			disabled_plugins = {
				"2html_plugin", -- HTML 转换插件
				"tohtml", -- HTML 转换功能
				"getscript", -- 脚本获取插件
				"getscriptPlugin", -- 脚本获取插件扩展
				"gzip",  -- GZIP 压缩支持
				"logipat", -- 逻辑模式匹配
				"netrw", -- 网络文件浏览器（使用 nvim-tree 替代）
				"netrwPlugin", -- 网络文件浏览器插件
				"netrwSettings", -- 网络文件浏览器设置
				"netrwFileHandlers", -- 网络文件处理器
				"matchit", -- 匹配增强插件
				"tar",   -- TAR 文件支持
				"tarPlugin", -- TAR 插件
				"rrhelper", -- 远程请求助手
				"spellfile_plugin", -- 拼写检查文件插件
				"vimball", -- Vimball 包管理
				"vimballPlugin", -- Vimball 插件
				"zip",   -- ZIP 文件支持
				"zipPlugin", -- ZIP 插件
				"tutor", -- Vim 教程
				"rplugin", -- 远程插件支持
				"syntax", -- 传统语法高亮（使用 Tree-sitter 替代）
				"synmenu", -- 语法菜单
				"optwin", -- 选项窗口
				"compiler", -- 编译器支持
				"bugreport", -- 错误报告
				"ftplugin", -- 文件类型插件
			},
		},
	},
}
