-- ============================================================================
-- nvim-cmp 自定义高亮组配置 (cmp-highlights.lua)
-- 为补全菜单提供增强的视觉效果和主题适配
-- ============================================================================

local M = {}

-- ============================================================================
-- 高亮组定义函数
-- ============================================================================
function M.setup_highlights()
	-- 获取当前主题的颜色
	local colors = require("base46").get_theme_tb("base_30")
	
	-- 自定义补全菜单背景 (基于 GitHub 讨论的方法)
	vim.api.nvim_set_hl(0, "CmpNormal", {
		fg = colors.white,
		bg = colors.darker_black,
	})

	-- 补全菜单选中项高亮
	vim.api.nvim_set_hl(0, "CmpSel", {
		fg = colors.black,
		bg = colors.blue,
		bold = true,
	})

	-- 文档窗口高亮
	vim.api.nvim_set_hl(0, "CmpDoc", {
		fg = colors.white,
		bg = colors.black2,
	})

	-- Ghost Text 高亮 (预览文本)
	vim.api.nvim_set_hl(0, "CmpGhostText", {
		fg = colors.grey_fg,
		italic = true,
	})

	-- ============================================================================
	-- 补全项类型图标高亮组 (带彩色背景)
	-- ============================================================================
	-- 图标背景色高亮组 (使用更鲜艳的颜色)
	local kind_highlights = {
		CmpItemKindText = { fg = "#000000", bg = "#CCCCCC" },
		CmpItemKindMethod = { fg = "#FFFFFF", bg = "#007ACC" },
		CmpItemKindFunction = { fg = "#FFFFFF", bg = "#007ACC" },
		CmpItemKindConstructor = { fg = "#000000", bg = "#FFFF00" },
		CmpItemKindField = { fg = "#FFFFFF", bg = "#00AA00" },
		CmpItemKindVariable = { fg = "#FFFFFF", bg = "#FF6600" },
		CmpItemKindClass = { fg = "#000000", bg = "#FFFF00" },
		CmpItemKindInterface = { fg = "#FFFFFF", bg = "#AA00AA" },
		CmpItemKindModule = { fg = "#FFFFFF", bg = "#00AAAA" },
		CmpItemKindProperty = { fg = "#FFFFFF", bg = "#00AA00" },
		CmpItemKindUnit = { fg = "#000000", bg = "#FF6600" },
		CmpItemKindValue = { fg = "#FFFFFF", bg = "#CC0000" },
		CmpItemKindEnum = { fg = "#000000", bg = "#FFFF00" },
		CmpItemKindKeyword = { fg = "#FFFFFF", bg = "#AA00AA" },
		CmpItemKindSnippet = { fg = "#FFFFFF", bg = "#CC0000" },
		CmpItemKindColor = { fg = "#FFFFFF", bg = "#FF00AA" },
		CmpItemKindFile = { fg = "#FFFFFF", bg = "#007ACC" },
		CmpItemKindReference = { fg = "#FFFFFF", bg = "#00AAAA" },
		CmpItemKindFolder = { fg = "#FFFFFF", bg = "#007ACC" },
		CmpItemKindEnumMember = { fg = "#FFFFFF", bg = "#FF6600" },
		CmpItemKindConstant = { fg = "#FFFFFF", bg = "#CC0000" },
		CmpItemKindStruct = { fg = "#000000", bg = "#FFFF00" },
		CmpItemKindEvent = { fg = "#FFFFFF", bg = "#AA00AA" },
		CmpItemKindOperator = { fg = "#FFFFFF", bg = "#00AAAA" },
		CmpItemKindTypeParameter = { fg = "#000000", bg = "#FFFF00" },
	}

	-- 应用补全项类型高亮
	for group, color in pairs(kind_highlights) do
		vim.api.nvim_set_hl(0, group, color)
	end

	-- ============================================================================
	-- 补全源高亮组
	-- ============================================================================
	vim.api.nvim_set_hl(0, "CmpItemMenu", {
		fg = colors.grey_fg2,
		italic = true,
	})

	-- 补全项文本高亮
	vim.api.nvim_set_hl(0, "CmpItemAbbr", {
		fg = colors.white,
	})

	-- 匹配的补全项文本高亮
	vim.api.nvim_set_hl(0, "CmpItemAbbrMatch", {
		fg = colors.blue,
		bold = true,
	})

	-- 模糊匹配的补全项文本高亮
	vim.api.nvim_set_hl(0, "CmpItemAbbrMatchFuzzy", {
		fg = colors.blue,
		bold = true,
	})

	-- 已弃用项目高亮
	vim.api.nvim_set_hl(0, "CmpItemAbbrDeprecated", {
		fg = colors.grey_fg,
		strikethrough = true,
	})
end

-- ============================================================================
-- 自动命令：主题更改时重新应用高亮
-- ============================================================================
function M.setup_autocmd()
	local augroup = vim.api.nvim_create_augroup("CmpHighlights", { clear = true })
	
	vim.api.nvim_create_autocmd("ColorScheme", {
		group = augroup,
		callback = function()
			-- 延迟执行以确保新主题已加载
			vim.defer_fn(function()
				M.setup_highlights()
			end, 100)
		end,
	})
end

-- ============================================================================
-- 初始化函数
-- ============================================================================
function M.setup()
	-- 设置高亮组
	M.setup_highlights()
	
	-- 设置自动命令
	M.setup_autocmd()
end

return M