# 主题切换指南

## 🎨 当前主题配置

您当前使用的是 **Catppuccin** 主题，这是一个现代化的颜色主题，支持多种颜色变体。

### 可用的 Catppuccin 颜色变体

1. **mocha** (默认) - 深色主题，最流行的选择
2. **frappe** - 深色主题，比 mocha 更亮一些
3. **macchiato** - 深色主题，更柔和的颜色
4. **latte** - 浅色主题，适合白天使用

## 🚀 主题切换方法

### 方法一：临时切换（重启后恢复）

在 Neovim 中直接执行命令：

```vim
:colorscheme catppuccin
:lua require('catppuccin').setup({flavour = 'mocha'}); vim.cmd('colorscheme catppuccin')
:lua require('catppuccin').setup({flavour = 'frappe'}); vim.cmd('colorscheme catppuccin')
:lua require('catppuccin').setup({flavour = 'macchiato'}); vim.cmd('colorscheme catppuccin')
:lua require('catppuccin').setup({flavour = 'latte'}); vim.cmd('colorscheme catppuccin')
```

### 方法二：永久切换（修改配置文件）

编辑 `/Users/dyx/.config/nvim/lua/plugins/init.lua` 文件：

```lua
config = function()
    require("catppuccin").setup({
        flavour = "mocha",  -- 在这里修改：mocha, frappe, macchiato, latte
        background = {
            light = "latte",
            dark = "mocha",
        },
        transparent_background = false,
        -- ... 其他配置
    })
    vim.cmd("colorscheme catppuccin")
end,
```

修改后重启 Neovim 即可。

## 🎯 便捷主题切换命令

为了更方便地切换主题，您可以使用以下方法：

### 1. 创建主题切换函数

在 `/Users/dyx/.config/nvim/lua/config/theme.lua` 中创建：

```lua
local M = {}

-- 主题切换函数
function M.switch_theme(flavour)
    flavour = flavour or "mocha"
    require('catppuccin').setup({flavour = flavour})
    vim.cmd('colorscheme catppuccin')

    -- 重新应用透明背景设置
    vim.defer_fn(function()
        require('config.highlights').setup_all_highlights()
    end, 100)

    print("主题已切换到: " .. flavour)
end

-- 可用的主题列表
M.themes = {
    "mocha",
    "frappe",
    "macchiato",
    "latte"
}

return M
```

### 2. 添加快捷键

在 `/Users/dyx/.config/nvim/lua/config/keymaps.lua` 中添加：

```lua
-- 主题切换快捷键
vim.keymap.set("n", "<leader>tm", "<cmd>lua require('config.theme').switch_theme('mocha')<cr>", { desc = "切换到 Mocha 主题" })
vim.keymap.set("n", "<leader>tf", "<cmd>lua require('config.theme').switch_theme('frappe')<cr>", { desc = "切换到 Frappe 主题" })
vim.keymap.set("n", "<leader>tmc", "<cmd>lua require('config.theme').switch_theme('macchiato')<cr>", { desc = "切换到 Macchiato 主题" })
vim.keymap.set("n", "<leader>tl", "<cmd>lua require('config.theme').switch_theme('latte')<cr>", { desc = "切换到 Latte 主题" })
```

### 3. 主题循环切换

创建一个循环切换函数：

```lua
function M.cycle_theme()
    local current_flavour = vim.g.catppuccin_flavour or "mocha"
    local themes = {"mocha", "frappe", "macchiato", "latte"}

    local next_index = 1
    for i, theme in ipairs(themes) do
        if theme == current_flavour then
            next_index = (i % #themes) + 1
            break
        end
    end

    local next_theme = themes[next_index]
    M.switch_theme(next_theme)
    vim.g.catppuccin_flavour = next_theme
end

-- 添加循环切换快捷键
vim.keymap.set("n", "<leader>tc", "<cmd>lua require('config.theme').cycle_theme()<cr>", { desc = "循环切换主题" })
```

## 🌟 主题预览

### Mocha (默认深色)
- 特点：深邃的背景色，高对比度
- 适合：夜间编程，护眼

### Frappe (深色)
- 特点：比 mocha 更明亮一些
- 适合：白天室内环境

### Macchiato (深色)
- 特点：更柔和的颜色，温暖色调
- 适合：长时间编程，减少眼部疲劳

### Latte (浅色)
- 特点：明亮清新的浅色主题
- 适合：白天使用，明亮环境

## ⚙️ 主题配置选项

Catppuccin 主题支持多种自定义选项：

```lua
require("catppuccin").setup({
    flavour = "mocha",
    background = {
        light = "latte",
        dark = "mocha",
    },
    transparent_background = false,  -- 设置为 true 可获得透明效果
    show_end_of_buffer = false,
    term_colors = false,
    dim_inactive = {
        enabled = false,
        shade = "dark",
        percentage = 0.15,
    },
    styles = {
        comments = { "italic" },
        conditionals = { "italic" },
        loops = {},
        functions = {},
        keywords = {},
        strings = {},
        variables = {},
        numbers = {},
        booleans = {},
        properties = {},
        types = {},
        operators = {},
    },
    color_overrides = {},
    custom_highlights = {},
    integrations = {
        cmp = true,
        gitsigns = true,
        nvimtree = true,
        treesitter = true,
        notify = false,
        mini = false,
        telescope = true,
    },
})
```

## 🔧 透明背景主题

如果您想要透明背景效果，可以在主题配置中设置：

```lua
transparent_background = true,
```

或者手动执行：
```vim
:lua require('catppuccin').setup({flavour = 'mocha', transparent_background = true}); vim.cmd('colorscheme catppuccin')
```

注意：您的配置已经包含了自定义的透明背景设置，所以即使 `transparent_background = false`，背景也会是透明的。

## 📝 使用建议

1. **首次使用**: 推荐从 `mocha` 开始，这是最受欢迎的选择
2. **长时间工作**: 尝试 `macchiato`，颜色更柔和
3. **白天使用**: 可以考虑 `frappe` 或 `latte`
4. **透明效果**: 您的配置已经优化了透明背景，所有主题都会保持透明效果

选择您喜欢的主题，享受美观的编程环境！🎨