# 🎨 主题切换快速开始

## 快捷键一览

| 快捷键 | 功能 | 说明 |
|--------|------|------|
| `<leader>tm` | 切换到 Mocha | 🌙 深邃的深色主题（默认） |
| `<leader>tf` | 切换到 Frappe | ☕ 明亮的深色主题 |
| `<leader>tmc` | 切换到 Macchiato | 🎨 柔和的深色主题 |
| `<leader>tl` | 切换到 Latte | ☀️ 清新的浅色主题 |
| `<leader>tc` | 循环切换主题 | 🔄 在所有主题间循环 |
| `<leader>ti` | 显示当前主题 | ℹ️ 查看当前使用的主题 |

## 立即开始使用

### 1. 重新启动 Neovim
重新启动 Neovim 以加载新的主题切换功能。

### 2. 尝试切换主题
在 Neovim 中按以下快捷键：

- 按 `,tm` 切换到 Mocha（默认深色）
- 按 `,tf` 切换到 Frappe（明亮深色）
- 按 `,tmc` 切换到 Macchiato（柔和深色）
- 按 `,tl` 切换到 Latte（浅色主题）

### 3. 循环浏览所有主题
按 `,tc` 可以在所有主题之间循环切换，找到您喜欢的颜色。

### 4. 查看当前主题
按 `,ti` 可以显示当前使用的主题信息。

## 主题特点

### 🌙 Mocha (推荐)
- 深邃的背景色，高对比度
- 适合夜间编程和护眼
- 最受欢迎的选择

### ☕ Frappe
- 比 mocha 更明亮的深色主题
- 适合白天室内使用
- 平衡的亮度和对比度

### 🎨 Macchiato
- 最柔和的深色主题
- 温暖的色调
- 适合长时间编程

### ☀️ Latte
- 明亮清新的浅色主题
- 适合白天使用
- 减少眼部疲劳

## 手动切换方法

如果您想临时切换主题（重启后恢复），可以直接执行：

```vim
:lua require('config.theme').switch_theme('mocha')
:lua require('config.theme').switch_theme('frappe')
:lua require('config.theme').switch_theme('macchiato')
:lua require('config.theme').switch_theme('latte')
```

## 永久更改主题

要永久更改默认主题，编辑配置文件：

1. 编辑 `/Users/dyx/.config/nvim/lua/plugins/init.lua`
2. 找到 `flavour = "mocha"` 这一行
3. 将 `"mocha"` 改为您想要的主题名称
4. 重启 Neovim

## 透明背景

您的配置已经包含了透明背景设置，所有主题都会自动应用透明效果，与桌面背景完美融合。

## 常见问题

**Q: 切换主题后透明背景消失了？**
A: 主题切换会自动重新应用透明背景设置，稍等片刻即可生效。

**Q: 如何重置到默认主题？**
A: 按 `,tm` 切换回 Mocha 主题，或者重启 Neovim。

**Q: 可以自定义主题颜色吗？**
A: 可以在主题配置中修改 `color_overrides` 和 `custom_highlights` 选项。

现在开始探索不同的主题，找到最适合您的编程风格吧！🚀