# NvimTree 增强功能说明

## 🎨 透明背景

NvimTree 现在支持透明背景，与您的桌面背景完美融合：

- **自动应用**: 打开 NvimTree 时自动应用透明背景
- **智能高亮**: 保持文字和图标的清晰度，只移除背景色
- **Git 状态**: Git 状态颜色保持不变，易于识别
- **光标行**: 当前行通过反色效果突出显示

## ⌨️ 翻页快捷键

在 NvimTree 窗口中，您可以使用以下快捷键进行翻页：

### 向下翻页
- **快捷键**: `Ctrl + J`
- **功能**: 向下半页滚动 (half-page down)

### 向上翻页
- **快捷键**: `Ctrl + K`
- **功能**: 向上半页滚动 (half-page up)
- **修复**: 已解决与搜索功能的冲突，现在可以正常使用

## 📋 其他快捷键参考

### 文件操作
- `Enter` / `o`: 打开文件
- `t`: 在新标签页打开
- `v`: 垂直分割打开
- `s`: 水平分割打开

### 目录树操作
- `E`: 展开所有目录
- `W`: 折叠所有目录
- `R`: 刷新目录树
- `q`: 关闭 NvimTree

### Git 操作
- `gc`: 清除 Git 书签
- `gm`: 列出 Git 书签
- `m`/`b`: 切换书签

### 搜索和过滤
- `f`: 开始实时过滤
- `F`: 清除过滤
- `S`: 搜索节点

## 🔧 配置位置

这些功能在以下配置文件中定义：

- **翻页快捷键**: `lua/config/nvimtree.lua`
- **透明背景**: `lua/config/highlights.lua` 和 `lua/config/autocmds.lua`
- **自动应用**: 当检测到 TailwindCSS 项目时自动启用

## 💡 使用提示

1. **快速导航**: 使用 Ctrl+J/K 快速浏览大型目录结构
2. **美观体验**: 透明背景让 NvimTree 与您的桌面环境完美融合
3. **效率提升**: 结合翻页和搜索功能，快速定位文件
4. **Git 集成**: 透明背景不影响 Git 状态显示，依然可以清楚看到文件变更状态

享受您的现代化 NvimTree 体验！🚀