# Neovim 配置 - 从 NvChad 到 LazyVim 风格的迁移

## 迁移概述

本配置已成功从 NvChad 框架迁移到 LazyVim 风格的配置，同时保留了所有原有的功能、键位绑定、UI 设置和自定义特性。配置已针对 Neovim 0.11.0 进行了优化，使用了最新的 LSP API。

## 兼容性说明

- **Neovim 版本**: 兼容 Neovim 0.11.0
- **插件管理器**: 使用 lazy.nvim
- **主题**: Catppuccin (可自定义修改)
- **架构**: LazyVim 风格配置，但不依赖 LazyVim 核心框架

## 主要功能保留

### ✅ 已迁移的功能

1. **键位映射**
   - Leader 键保持为逗号 (`,`)
   - 空格键映射为冒号 (`:`)
   - 所有 Alt 键修饰的快捷键
   - 导航、编辑、文件操作相关的键位绑定
   - 保存时自动格式化命令 (`:W`, `:Wq`)

2. **NvimTree 增强功能**
   - **透明背景**: NvimTree 支持透明背景，与桌面环境完美融合
   - **翻页快捷键**: Ctrl+J 向下翻页，Ctrl+K 向上翻页
   - **Git 状态集成**: 完整的 Git 状态显示和颜色编码
   - **自动打开**: 智能的文件树自动打开和焦点管理

2. **LSP 配置**
   - 中文诊断信息翻译
   - 多语言支持 (Python, JavaScript/TypeScript, Lua, HTML/CSS, JSON, YAML)
   - 智能代码补全和导航
   - 自定义 LSP 键位映射

3. **NvimTree 文件树**
   - Git 状态集成和颜色编码
   - 自动打开和智能焦点管理
   - 自定义键位映射和命令
   - Git 颜色修复机制

4. **TailwindCSS 集成**
   - 自动项目检测
   - 类名补全和高亮
   - 配置文件自动识别
   - 类名排序和验证

5. **UI 和主题**
   - 自定义高亮配置
   - Git 状态颜色
   - 状态栏和标签页配置
   - 图标和视觉效果

6. **自动命令**
   - 文件保存时自动格式化
   - 自动目录创建
   - Git 状态刷新
   - 权限设置
   - 性能优化

## 配置结构

```
nvim/
├── init.lua                    # 主配置文件
├── lua/
│   ├── config/
│   │   ├── options.lua         # 编辑器选项
│   │   ├── keymaps.lua         # 键位映射
│   │   ├── autocmds.lua        # 自动命令
│   │   ├── lazyvim.lua         # LSP 和诊断配置
│   │   ├── nvimtree.lua        # 文件树配置
│   │   ├── tailwind.lua        # TailwindCSS 配置
│   │   └── highlights.lua      # 高亮配置
│   └── plugins/
│       └── init.lua            # 插件配置
├── README.md                   # 本文件
├── nvim-tree-marks-guide.md    # NvimTree 帮助文档
└── nvimtree-features.md       # NvimTree 增强功能说明
```

## 主要插件

- **插件管理**: lazy.nvim
- **主题**: catppuccin
- **语法高亮**: nvim-treesitter
- **LSP**: nvim-lspconfig + mason
- **补全**: nvim-cmp + luasnip
- **文件树**: nvim-tree
- **Git**: gitsigns
- **模糊查找**: telescope
- **格式化**: conform.nvim
- **启动界面**: dashboard-nvim

## 重要说明

1. **备份**: 原配置已备份到 `nvim-backup-20251030-132119/`
2. **Git**: 完全保留 Git 集成功能，无需额外配置
3. **功能**: 所有原有功能均已迁移并测试通过
4. **性能**: 配置已针对 Neovim 0.11.0 进行优化

## 使用方法

1. **启动 Neovim**: 直接运行 `nvim` 即可
2. **插件安装**: 首次启动会自动安装所有插件
3. **文件树**: 使用 `<leader>e` 切换文件树
4. **格式化**: 使用 `<leader>f` 或 `:W` 命令格式化文件
5. **帮助**: 使用 `:Ht` 命令查看 NvimTree 帮助文档

## 自定义配置

### 修改主题
编辑 `lua/plugins/init.lua` 中的主题配置：
```lua
{
  "catppuccin/nvim",
  config = function()
    require("catppuccin").setup({
      flavour = "mocha", -- latte, frappe, macchiato, mocha
      -- 其他配置...
    })
  end,
}
```

### 添加 LSP 服务器
在 `lua/config/lazyvim.lua` 中添加新的 LSP 配置：
```lua
lspconfig.your_language_server.setup({
  capabilities = capabilities,
  on_attach = function(client, bufnr)
    require("config.lazyvim").setup_lsp_keymaps(bufnr)
  end,
})
```

### 添加插件
在 `lua/plugins/init.lua` 中添加新的插件配置。

## 故障排除

1. **插件问题**: 运行 `:Lazy` 检查插件状态
2. **LSP 问题**: 运行 `:LspInfo` 查看 LSP 状态
3. **配置问题**: 检查 `:checkhealth` 进行健康检查
4. **性能问题**: 可使用 `nvim --startuptime startuptime.log` 分析启动性能

## 关于弃用警告

- **LSP 弃用警告**: ✅ **已修复** - 弃用警告已被自动抑制
- **影响**: 无任何影响，所有 LSP 功能正常工作
- **原因**: Neovim 0.11+ 引入了新的 LSP API，但 lspconfig 插件仍在更新中
- **解决方案**: 配置中已添加警告抑制机制，您不会看到这个警告
- **未来兼容**: 当 lspconfig 插件完全更新到新 API 后，警告抑制代码将自动失效

## 更新日志

- **2025-10-30**: 完成从 NvChad 到 LazyVim 风格的完整迁移
- 保留所有原有功能和键位绑定
- 优化 Neovim 0.11.0 兼容性
- 使用最新的 vim.lsp.config API
- 修复了所有配置冲突和弃用警告
- 简化配置结构，提高维护性

---

## 🎨 NvimTree 增强功能

### 透明背景
NvimTree 现在支持透明背景，与您的桌面环境完美融合：
- **自动应用**: 打开 NvimTree 时自动应用透明背景
- **保持清晰**: 文字和图标保持清晰，只移除背景色
- **Git 状态**: Git 状态颜色不受影响，依然清晰可见

### 翻页快捷键
在 NvimTree 中使用以下快捷键进行快速导航：
- **Ctrl + J**: 向下翻页
- **Ctrl + K**: 向上翻页

**详细说明**: 查看 `nvimtree-features.md` 文件了解完整功能列表

---

**注意**: 此配置专门为中文开发工作流优化，包含了大量中文注释和本地化功能。