# iFlow CLI - Neovim 配置指南

## 🎯 项目概述

这是一个基于 **NvChad** 框架的高度定制化的 Neovim 配置，专为现代前端开发而设计。配置集成了现代化的开发工具链，提供了丰富的功能包括智能代码补全、语法高亮、文件管理、Git 集成、代码格式化等。

### 🏗️ 核心技术栈

- **框架**: NvChad v2.5 (现代化 Neovim 配置框架)
- **插件管理**: Lazy.nvim (高性能插件管理器)
- **主题系统**: Base46 (NvChad 主题系统)
- **语言服务器**: LSP + Mason (多语言支持，含中文诊断)
- **代码补全**: nvim-cmp + TailwindCSS 补全 + 颜色预览
- **文件管理**: nvim-tree (增强版文件浏览器 + Git集成)
- **代码格式化**: Conform.nvim + Prettier + 多语言支持
- **标签管理**: 自适应宽度 + 智能活跃状态检测

## 🚀 快速开始

### 安装依赖

```bash
# 确保已安装 Neovim 0.7+
nvim --version

# 安装 Node.js (用于 LSP 服务器和格式化工具)
curl -fsSL https://deb.nodesource.com/setup_lts.x | sudo -E bash -
sudo apt-get install -y nodejs

# 安装 Git (必需)
git --version
```

### 首次启动

```bash
# 克隆配置到配置目录
git clone https://github.com/DanielDu87/vimconfig.git ~/.config/nvim

# 启动 Neovim，Lazy.nvim 会自动安装所有插件
nvim

# 在 Neovim 中安装 LSP 服务器
:Mason
# 然后按 i 安装推荐的服务器
```

### 基本操作

```bash
# 打开/关闭文件树（自动刷新Git状态）
<M-q> 或 :NvimTreeToggle

# 打开终端
<leader>t

# 文件搜索
<leader>ff

# Git 状态
<leader>gs

# 显示帮助文档
:Ht 或 :ht
```

## 🛠️ 核心功能详解

### 📁 文件管理系统 (nvim-tree)

### 🏷️ 批量文件标记系统
- **多选文件标记**: 使用 `m` 键标记多个文件
- **批量操作**: 复制/移动/删除/移至垃圾箱
- **标记导航和清理功能**
- **批量操作进度**: 显示处理进度和结果统计
- **智能冲突处理**: 逐个文件处理冲突，提供覆盖/重命名/取消选项

#### 智能剪贴板操作
- **单文件复制**: `yy` 或 `cp`
- **单文件剪切**: `x` 或 `mv`
- **智能粘贴**: `p` (支持冲突处理)
- **清空剪贴板**: `cc`

#### 文件冲突处理
当粘贴文件时遇到同名文件，系统会提供三种选择：
1. **覆盖 (Y)**: 替换现有文件
2. **重命名 (R)**: 输入新文件名
3. **取消 (N)**: 跳过此文件

### 🎨 主题和界面

#### 主题配置
- **当前主题**: OneDark (支持透明背景)
- **主题切换**: 在 `lua/chadrc.lua` 中修改 `theme` 参数
- **透明度**: 默认启用，可在配置中关闭

#### 自定义高亮
- **当前行**: 浅灰色背景 (`#bfbfbf`)
- **当前行号**: 金色加粗 (`#e5c385`)
- **活跃缓冲区**: 白色加粗下划线
- **Git目录**: 强制显示为浅灰色 (`#8a8a8a`)
- **被忽略文件**: 灰色显示，保持视觉一致性

### 🔧 开发工具集成

#### LSP 语言服务器支持
- **HTML**: vscode-html-language-server + 中文诊断信息
- **CSS/SCSS**: vscode-css-language-server + 中文诊断信息
- **JavaScript/TypeScript**: ts_ls + TailwindCSS LSP + 中文诊断
- **Python**: pyright + Django支持 + 中文诊断
- **Go**: gopls + 中文诊断
- **TailwindCSS**: tailwindcss-language-server + 颜色预览

#### 代码格式化
- **HTML**: Prettier + 自定义后处理器（移除多余空行）
- **CSS**: Prettier + 注释空格规范化
- **JavaScript/TypeScript**: Prettier + 注释空格规范化
- **Python**: Black + 注释空格规范化
- **Go**: gofmt + 注释空格规范化
- **其他语言**: Conform.nvim 统一处理

#### 特殊功能
- **HTML 标签自动同步**: 修改开始标签时自动更新结束标签
- **TailwindCSS 颜色预览**: 在补全时显示颜色方块
- **文件模板系统**: 快速创建标准文件结构
- **LSP签名帮助**: 手动触发 (`<leader>sh` 或 `<C-s>`)
- **自适应标签栏**: 智能宽度调整和活跃状态检测
- **中文删除确认**: 安全的文件删除操作
- **启动时自动打开**: 根据启动参数智能处理文件树

## 📋 配置文件结构

```
~/.config/nvim/
├── init.lua                    # 主配置文件
├── lua/
│   ├── chadrc.lua             # NvChad 主题和 UI 配置（含自适应标签栏）
│   ├── configs/
│   │   ├── plugins.lua        # 自定义插件列表
│   │   ├── lspconfig.lua      # LSP 服务器配置（含中文诊断）
│   │   ├── nvimtree.lua       # 文件树增强配置（含Git集成）
│   │   ├── core.lua           # 核心选项和兼容性修复
│   │   ├── conform.lua        # 代码格式化配置
│   │   ├── autocmds.lua       # 自动命令配置
│   │   ├── highlights.lua     # 高亮和颜色配置
│   │   └── ...               # 其他配置模块
│   └── plugins/               # 自定义插件目录
├── templates/                 # 文件模板目录
├── colors/                    # 自定义颜色方案
├── .prettierrc.js            # Prettier 配置文件
└── ...                       # 其他资源和文档
```

## ⚙️ 高级配置

### 自定义插件添加

在 `lua/configs/plugins.lua` 中添加新插件：

```lua
table.insert(plugins, {
  "作者/插件名称",
  config = function()
    require("插件名称").setup({
      -- 插件配置
    })
  end,
  event = "BufReadPost",  -- 懒加载触发事件
})
```

### LSP 服务器配置

在 `lua/configs/lspconfig.lua` 中添加新语言服务器：

```lua
-- 添加到 servers 列表
local servers = { "html", "cssls", "your_server" }

-- 或自定义配置
require("lspconfig").your_server.setup({
  on_attach = custom_on_attach,
  capabilities = require("nvchad.configs.lspconfig").capabilities,
  settings = {
    -- 服务器特定配置
  }
})
```

### 主题自定义

在 `lua/chadrc.lua` 中修改主题设置：

```lua
M.base46 = {
  theme = "gruvbox",  -- 主题名称
  transparency = true,  -- 透明背景
  hl_override = {
    -- 自定义高亮颜色
    CursorLine = { bg = "#your_color" },
    TbBufOn = { fg = "#ffffff", bold = true, underline = true }, -- 活跃缓冲区
  }
}
```

### 自适应标签栏配置

标签栏支持智能宽度调整和活跃状态检测：
- 自动计算文件名宽度，限制在12-30字符之间
- 智能检测当前窗口类型，保持正确的活跃状态
- 支持文件图标和透明背景
- 最多显示8个缓冲区，自动滚动到当前文件

### 🎯 使用技巧

### 文件树高效操作

1. **快速导航**: 使用 `j/k` 移动，`Ctrl+j/k` 翻页
2. **多选操作**: `m` 标记多个文件，然后使用批量命令
3. **智能跳转**: `mn`/`mp` 在标记文件间跳转
4. **路径复制**: `y` (文件名), `Y` (相对路径), `gy` (绝对路径)
5. **批量操作**: `ty` 批量复制，`tm` 批量移动，显示处理进度
6. **同目录检测**: 自动阻止同目录内的粘贴操作，防止意外复制

### 代码编辑增强

1. **快速补全**: Tab 键触发补全，TailwindCSS 类名有颜色预览
2. **标签同步**: 修改 HTML 标签时自动同步结束标签
3. **文件模板**: 使用模板快速创建标准文件结构
4. **Git 集成**: 文件树中直接显示 Git 状态，自动刷新颜色
5. **LSP签名帮助**: `<leader>sh` 或 `<C-s>` 手动触发签名帮助
6. **中文诊断**: LSP错误提示显示中文翻译，更易理解

### 快捷键记忆

- **文件树**: `<M-q>` 开关，`<leader>e` 聚焦
- **搜索**: `<leader>ff` 文件搜索，`<leader>fg` 文本搜索
- **终端**: `<leader>t` 打开终端
- **缓冲区**: `<leader>x` 关闭当前，`<leader>b` 切换缓冲区

## 🔧 故障排除

### 常见问题

#### 1. 插件未自动安装
```bash
# 手动触发插件安装
:NvimTreeToggle
:Lazy sync
```

#### 2. LSP 服务器未工作
```bash
# 检查 Mason 安装的服务器
:Mason
# 重新安装有问题的服务器
```

#### 3. 文件树 Git 颜色不显示
```bash
# 确保在项目根目录有 .git 文件夹
# 检查 Git 是否安装
git --version
```

#### 4. 主题颜色异常
```bash
# 重新加载主题配置
:colorscheme onedark
# 或重启 Neovim
```

#### 5. Git目录颜色不显示为灰色
```bash
# 确保 .git 目录被正确识别
# 检查 NvimTree 是否正确加载
:NvimTreeToggle
# 强制刷新Git状态
:lua require('nvim-tree.git').reload()
```

#### 6. LSP中文诊断不生效
```bash
# 检查语言服务器是否正确安装
:Mason
# 重新安装有问题的服务器
# 确保配置文件中的中文映射生效
```

#### 7. 批量操作无响应
```bash
# 检查是否有文件被标记
# 使用 :NvimTreeA7Clear 清除所有标记后重试
# 查看是否有同目录操作被阻止的提示
```

### 性能优化

- **启动速度**: 使用 Lazy.nvim 的懒加载机制
- **大文件处理**: 文件树有过滤器避免加载大目录
- **Git 性能**: 优化的 Git 状态检测，减少超时时间至100ms
- **文件系统监控**: 智能防抖机制，延迟500ms减少频繁更新
- **自适应标签栏**: 限制显示8个缓冲区，避免过多标签影响性能
- **Django项目优化**: 自动忽略staticfiles、logs等目录减少监控负载

## 📚 学习资源

### 官方文档
- [NvChad 文档](https://nvchad.com/docs/)
- [Neovim 文档](https://neovim.io/doc/)
- [Lazy.nvim 文档](https://github.com/folke/lazy.nvim)

### 相关插件
- [nvim-tree](https://github.com/nvim-tree/nvim-tree.lua)
- [nvim-cmp](https://github.com/hrsh7th/nvim-cmp)
- [conform.nvim](https://github.com/stevearc/conform.nvim)

## 🤝 贡献指南

1. **Fork 项目**并创建特性分支
2. **遵循代码风格**: 使用现有配置中的格式化和命名约定
3. **测试配置**: 确保修改不会破坏现有功能
4. **更新文档**: 修改 IFLOW.md 以反映新功能
5. **提交 PR**: 详细描述更改内容和原因

## 📄 许可证

本项目基于 NvChad 框架，遵循相应的开源许可证。自定义部分采用 MIT 许可证。

---

*最后更新: 2025年9月15日*