# Repository Guidelines

## Project Structure & Module Organization
- `init.lua`: Main entry; bootstraps `lazy.nvim` and loads modules.
- `lua/configs/`: Feature modules (e.g., `lspconfig.lua`, `conform.lua`, `nvimtree.lua`, `autocmds.lua`). Require via `require("configs.<name>")`.
- `lua/plugins/`: Plugin spec and plugin-specific configs (`init.lua`, `configs/*`).
- `colors/`, `templates/`: UI themes and snippet/template assets.
- `lazy-lock.json`: Plugin lockfile (commit changes after `Lazy sync`).
- `.prettierrc.js`: Shared formatter settings for web assets.
- Legacy `plugins/` (vimscript bundles) kept for reference; prefer `lazy.nvim` in `lua/plugins`.

## Build, Test, and Development Commands
- `nvim --headless "+Lazy sync" +qa`: Install/update plugins per `lua/plugins` and update `lazy-lock.json`.
- `nvim --headless "+checkhealth" +qa`: Run health checks for core and plugins.
- `nvim --startuptime startuptime.log -c qa`: Profile startup; inspect `startuptime.log`.
- `stylua lua`: Format Lua (tabs, width 4). If unavailable, run inside Neovim: `:lua vim.cmd('write') require('conform').format({ async=false })`.
- `prettier --check "**/*.{html,css,js,ts,json,md,yaml,yml}"`: Verify web assets; `--write` to fix.

## Coding Style & Naming Conventions
- Indentation: Tabs, width 4 (Lua and Prettier). Keep lines long where needed; HTML uses Tailwind-aware Prettier.
- Comment spacing: Normalized by Conform’s `comment_space` post-processor.
- Lua modules: lowercase, descriptive; use hyphens or underscores (e.g., `tailwind-auto-config.lua`, `simple-bookmarks.lua`).
- Keep user commands and mappings scoped in their module (see `configs/mappings.lua`).

## Testing Guidelines
- Smoke tests: `:checkhealth`, open NvimTree, edit HTML/JS/CSS and run `:lua require('conform').format()`.
- LSP: Open representative files and confirm diagnostics, completion, and formatting.
- Visual: After color or UI changes, capture a before/after screenshot of affected views (e.g., NvimTree, statusline).

## Commit & Pull Request Guidelines
- Commits: Prefer Conventional Commits. Scopes: `configs`, `plugins`, `keymaps`, `nvimtree`, `lsp`, `format`.
  - Examples: `feat(configs): add Tailwind auto config`, `fix(nvimtree): restore git colors on startup`.
- PRs: Clear description, rationale, affected modules, steps to validate, and screenshots for UI changes. Reference issues when applicable.

## Security & Configuration Tips
- Do not commit secrets or machine-specific absolute paths. Test on a clean Neovim with `--clean` if diagnosing env issues.
