// 预设：统一使用制表符缩进（宽度 4），并为 HTML 做了特别处理。
// 说明：
// 1) 我们保留 Prettier 作为主格式化器来处理 HTML 的缩进/对齐/属性换行等整体风格；
// 2) 由于 Prettier 没有直接“禁止 head/body 上下空行”的开关，
//    我们在 conform.nvim 中串联了一个自定义后处理器 html_noblank（见 lua/configs/conform.lua），
//    它只删除 <head>/<body> 标签上下多余的空行，其他格式化结果保持不变；
// 3) 这里的 Prettier 配置负责提供通用的缩进和 HTML 空白策略，尽量减少无谓换行；
// 4) 若未来需要进一步精简其他标签周围的空行，可扩展 html_noblank 的正则规则。

module.exports = {
	// Prettier 插件配置
	plugins: ["prettier-plugin-tailwindcss"],

	// 基础风格：使用 Tab 缩进且宽度 4
	useTabs: true,
	tabWidth: 4,

	// HTML 空白处理选择 "css"：遵循 CSS 的空白折叠语义，避免过度保留空白
	htmlWhitespaceSensitivity: "css",

	// 其余通用设置
	printWidth: 200,
	semi: true,
	singleQuote: false,
	trailingComma: "none",
	bracketSpacing: true,
	// 将闭合尖括号放在同一行，减少多余换行
	bracketSameLine: true,
	arrowParens: "avoid",
	endOfLine: "lf",
	insertPragma: false,
	proseWrap: "preserve",
	quoteProps: "as-needed",
	requirePragma: false,
	vueIndentScriptAndStyle: false,
	embeddedLanguageFormatting: "auto",

	// HTML 专用覆盖：进一步减少不必要换行，同时保持语义正确
	overrides: [
		{
			files: "*.html",
			options: {
				parser: "html",
				htmlWhitespaceSensitivity: "css",
				bracketSameLine: true,
				// 设置极大的行宽，避免任何不必要的换行
				printWidth: 1000,
				// 不强制单属性独占一行，避免额外空白
				singleAttributePerLine: false,
			},
		},
		{
			files: "*.htm",
			options: {
				parser: "html",
				htmlWhitespaceSensitivity: "css",
				bracketSameLine: true,
				// 设置极大的行宽，避免任何不必要的换行
				printWidth: 1000,
				// 不强制单属性独占一行，避免额外空白
				singleAttributePerLine: false,
			},
		},
	],
};