// ==UserScript==
// @name         采购表单数据提取
// @namespace    http://tampermonkey.net/
// @version      0.1
// @description  提取采购计划表单数据
// @author       DanielDu
// @match        https://ims.ynydtk.com:8443/buyv2/*
// @grant        none
// ==/UserScript==

(function() {
	"use strict";

	// 创建提取按钮
	function createExtractButton() {
		const button = document.createElement("button");
		button.classList.add("extract_form_data");
		button.textContent = "提取表单数据";
		button.style.position = "fixed";
		button.style.top = "185px";
		button.style.left = "50%";
		button.style.transform = "translateX(-50%)";
		button.style.zIndex = "9999";
		button.style.padding = "10px";
		button.style.backgroundColor = "#4caf50";
		button.style.color = "white";
		button.style.border = "none";
		button.style.borderRadius = "4px";
		button.style.cursor = "pointer";
		button.addEventListener("mouseover", () => {
			button.style.fontWeight = "bold";
		});
		button.addEventListener("mouseout", () => {
			button.style.fontWeight = "normal";
		});
		document.body.appendChild(button);
		button.addEventListener("click", extractFormData);
	}

	// 提取数据的主函数
	function extractFormData() {
		const formData = [];
		const rows = document.querySelectorAll("tr[data-v-0ebde73c]");

		rows.forEach(row => {
			const cells = row.querySelectorAll("td[data-v-0ebde73c]");
			const rowData = [];

			cells.forEach(cell => {
				rowData.push(cell.textContent.trim());
			});

			formData.push(rowData);
		});

		// 格式化输出数据
		let output = "采购表单数据：\n\n";
		formData.forEach(row => {
			if (row.length === 2) {
				output += `${row[0]}\n${row[1]}\n`;
			} else if (row.length === 1) {
				output += `${row[0]}\n`;
			}
			output += "---------------------\n";
		});


		// 创建结果显示框
		const resultDiv = document.createElement("textarea");
		resultDiv.classList.add("get_info");
		resultDiv.style.position = "fixed";
		resultDiv.style.width = "40%";
		resultDiv.style.height = "70%";
		resultDiv.style.top = "50%";
		resultDiv.style.left = "50%";
		resultDiv.style.transform = "translate(-50%, -50%)";
		resultDiv.style.padding = "20px";
		resultDiv.style.backgroundColor = "white";
		resultDiv.style.border = "1px solid #ccc";
		resultDiv.style.borderRadius = "5px";
		resultDiv.style.zIndex = "10000";
		resultDiv.style.maxHeight = "80vh";
		resultDiv.style.overflow = "auto";
		resultDiv.style.maxWidth = "80vw";
		resultDiv.style.whiteSpace = "pre-wrap";
		resultDiv.style.boxShadow = "0 4px 6px rgba(0, 0, 0, 0.1)";

		// 添加关闭按钮
		const closeButton = document.createElement("button");
		closeButton.textContent = "关闭";
		closeButton.style.position = "absolute";
		closeButton.style.top = "10px";
		closeButton.style.right = "10px";
		closeButton.style.padding = "5px 10px";
		closeButton.style.backgroundColor = "#f44336";
		closeButton.style.color = "white";
		closeButton.style.border = "none";
		closeButton.style.borderRadius = "3px";
		closeButton.style.cursor = "pointer";

		closeButton.addEventListener("click", () => {
			document.body.removeChild(resultDiv);
		});

		// 添加复制按钮
		const copyButton = document.createElement("button");
		copyButton.textContent = "复制内容";
		copyButton.style.position = "absolute";
		copyButton.style.top = "10px";
		copyButton.style.right = "70px";
		copyButton.style.padding = "5px 10px";
		copyButton.style.backgroundColor = "#2196f3";
		copyButton.style.color = "white";
		copyButton.style.border = "none";
		copyButton.style.borderRadius = "3px";
		copyButton.style.cursor = "pointer";

		copyButton.addEventListener("click", () => {
			navigator.clipboard.writeText(output).then(() => {
				copyButton.textContent = "已复制！";
				setTimeout(() => {
					copyButton.textContent = "复制内容";
				}, 2000);
			});
		});

		resultDiv.appendChild(closeButton);
		resultDiv.appendChild(copyButton);
		resultDiv.appendChild(document.createTextNode(output));
		document.body.appendChild(resultDiv);

		// 输出到控制台
		console.log(output);

		// 点击其他地方关闭结果框，不包含extract_form_data按钮
		document.addEventListener("click", event => {
			if (!event.target.classList.contains("extract_form_data") && !event.target.classList.contains("get_info")) {
				document.body.removeChild(resultDiv);
			}
		});
	}

	// 初始化
	createExtractButton();
})();
