// ==UserScript==
// @name         企信-合并功能脚本
// @namespace    http://tampermonkey.net/
// @version      1.0
// @author       You
// @match        https://ims.ynydtk.com:8443/buyv2/
// @match        https://qx.ynydtk.cn:8443/buyv2/*
// @require      https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js
// @grant        GM_setClipboard
// @grant        GM_addStyle
// @grant        GM_getValue
// @grant        GM_setValue
// @run-at       document-end
// ==/UserScript==

; (function () {
	'use strict';

	const href = window.location.href;

	// 通用：根据内容自动调整禁用 textarea 的高度（IMS 页面与企信页面都使用）
	function autoAdjustDisabledTextareas() {
		const textareas = document.querySelectorAll('.el-textarea__inner');
		textareas.forEach((textarea) => {
			if (textarea.disabled) {
				textarea.style.height = 'auto';
				textarea.style.height = textarea.scrollHeight + 'px';
			}
		});
	}

	// ---------------- 企信：工具按钮总开关（左上角） ----------------
	function initQXToolsVisibilityToggle() {
		// 仅在企信页面生效，且防止重复创建
		if (!href.startsWith('https://qx.ynydtk.cn:8443/buyv2/')) return;
		if (document.getElementById('tm-toggle-tools-visibility-btn')) return;

		const toggleBtn = document.createElement('button');
		toggleBtn.id = 'tm-toggle-tools-visibility-btn';
		toggleBtn.textContent = '隐藏工具';
		toggleBtn.classList.add('tm-tool-btn');
		toggleBtn.style.position = 'fixed';
		toggleBtn.style.top = '70px';
		toggleBtn.style.left = '20px';
		toggleBtn.style.zIndex = '9999';
		toggleBtn.style.padding = '8px 16px';
		toggleBtn.style.backgroundColor = '#909399';
		toggleBtn.style.color = '#fff';
		toggleBtn.style.border = 'none';
		toggleBtn.style.borderRadius = '4px';
		toggleBtn.style.cursor = 'pointer';
		toggleBtn.style.boxShadow = '0 2px 10px rgba(0, 0, 0, 0.2)';
		toggleBtn.style.fontSize = '13px';
		toggleBtn.style.fontWeight = 'bold';
		toggleBtn.style.transition = 'all 0.2s ease-in-out';

		let toolsHidden = false;

		toggleBtn.addEventListener('click', () => {
			toolsHidden = !toolsHidden;

			const allToolButtons = document.querySelectorAll('.tm-tool-btn');
			allToolButtons.forEach((btn) => {
				// 不隐藏左上角自己的切换按钮
				if (btn === toggleBtn) return;
				// 只控制脚本自己加的工具按钮，不会影响页面原生按钮（如“组上交”之类）
				if (toolsHidden) {
					btn.dataset._tm_prevDisplay = btn.style.display || '';
					btn.style.display = 'none';
				} else {
					btn.style.display = btn.dataset._tm_prevDisplay || '';
				}
			});

			toggleBtn.textContent = toolsHidden ? '显示工具' : '隐藏工具';
		});

		// 打印时隐藏按钮（样式在 initQXPurchaseInfoTools 中统一处理）
		if (document.readyState === 'complete' || document.readyState === 'interactive') {
			document.body.appendChild(toggleBtn);
		} else {
			document.addEventListener('DOMContentLoaded', () => {
				document.body.appendChild(toggleBtn);
			});
		}
	}

	// IMS 域名：采购内容概况自适应高度（保持原始 @match 范围）
	if (href.startsWith('https://ims.ynydtk.com:8443/buyv2/')) {
		initIMSAdjustHeight();
	}

	// 企信域名：采购信息提取 + 样式切换器（保持原始 @match 范围）
	if (href.startsWith('https://qx.ynydtk.cn:8443/buyv2/')) {
		initQXPurchaseInfoTools();
		initQXStyleToggleTools();
		initQXToolsVisibilityToggle();
	}

	// ---------------- IMS：采购内容概况自适应高度 ----------------
	function initIMSAdjustHeight() {
		// 创建按钮
		function createButton() {
			const button = document.createElement('button');
			button.textContent = '调整高度';
			button.classList.add('tm-tool-btn');
			button.style.cssText = `
            position: fixed;
			height: 35px;
            top: 70px;
            left: 49%;
				transform: translate(-50%);
            z-index: 9999;
            padding: 10px 20px;
            background-color: #409EFF;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
			font-weight: bold !important;
				font-size: 14px;
        `;
			document.body.appendChild(button);
			button.addEventListener('click', adjustTextareas);
		}

		// 调整文本区域高度
		function adjustTextareas() {
			autoAdjustDisabledTextareas();
		}

		// 为 IMS 页面注入通用按钮 hover/active 样式
		(function injectCommonButtonStyle() {
			if (document.getElementById('tm-common-button-style')) return;
			const style = document.createElement('style');
			style.id = 'tm-common-button-style';
			style.textContent = `
            .tm-tool-btn:hover {
                transform: translateY(-2px);
                box-shadow: 0 4px 14px rgba(0, 0, 0, 0.25) !important;
                filter: brightness(1.06);
            }
            .tm-tool-btn:active {
                transform: translateY(0);
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2) !important;
                filter: brightness(0.95);
            }
        `;
			document.head.appendChild(style);
		})();

		// 等待页面加载完成
		if (document.readyState === 'complete' || document.readyState === 'interactive') {
			setTimeout(createButton, 1000);
		} else {
			document.addEventListener('DOMContentLoaded', function () {
				setTimeout(createButton, 1000);
			});
		}
	}

	// ---------------- 企信：采购信息提取 + 创建目录 ----------------
	function initQXPurchaseInfoTools() {
		// 如果未来不再使用延时选择器，可以删除这两个常量及 extractValueAfterDelay
		const delayedInputSelector =
			'#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(4) > div > div > div > div.el-input.el-input--small.is-disabled.el-input--suffix > input';
		const delayDuration = 2000;

		let extractedData = null;

		const buttonContainer = document.createElement('div');
		buttonContainer.id = 'purchase-info-button-container';
		buttonContainer.style.position = 'fixed';
		buttonContainer.style.top = '120px';
		buttonContainer.style.left = '53%';
		buttonContainer.style.transform = 'translateX(-50%)';
		buttonContainer.style.zIndex = '9999';
		buttonContainer.style.display = 'flex';
		buttonContainer.style.gap = '20px';

		const style = document.createElement('style');
		style.textContent = `
        @media print {
				#extract-purchase-info-btn,
				#create-directory-btn,
				#capture-screenshot-btn,
				#tm-toggle-tools-visibility-btn,
				#tm-toggle-tools-visibility-btn-center {
                display: none !important;
            }
        }

        /* 居中切换隐藏按钮：低不透明度，hover时完全不透明 */
        #tm-toggle-tools-visibility-btn-center {
            opacity: 0.2 !important;
            transition: opacity 0.3s ease-in-out !important;
        }
        #tm-toggle-tools-visibility-btn-center:hover {
            opacity: 1 !important;
        }

        /* 第一行和第二行对应按钮宽度和高度统一 - 确保从一开始就对齐 */
        #toggle-auto-copy-btn,
        #extract-purchase-info-btn {
            width: 130px !important;
            box-sizing: border-box !important;
        }
        #adjust-height-btn,
        #create-directory-btn {
            width: 100px !important;
            height: 38px !important;
            box-sizing: border-box !important;
        }
        #toggle-style-btn,
        #capture-screenshot-btn {
            width: 100px !important;
            height: 38px !important;
            box-sizing: border-box !important;
        }

        /* 所有工具按钮通用 hover/active 特效 */
        .tm-tool-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 14px rgba(0, 0, 0, 0.25) !important;
            filter: brightness(1.06);
        }
        .tm-tool-btn:active {
            transform: translateY(0);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2) !important;
            filter: brightness(0.95);
        }

        .copy-success-toast {
            position: fixed;
            background-color: #67c23a;
            color: white;
            padding: 12px 24px;
            border-radius: 6px;
            font-size: 14px;
            font-weight: bold;
            z-index: 10000;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            opacity: 1;
            transition: opacity 0.5s ease-out;
        }
        .copy-success-toast.fade-out {
            opacity: 0;
        }

			/* --- 截图美化专用样式：仅在 body.screenshot-mode 下生效 --- */

			/* 去掉“流转列表”等记录表的粗边框和多余网格线 */
			body.screenshot-mode .recordListTable .el-table,
			body.screenshot-mode .recordListTable .el-table__header-wrapper,
			body.screenshot-mode .recordListTable .el-table__body-wrapper {
				border: none !important;
				box-shadow: none !important;
				background-color: #ffffff !important;
			}

			body.screenshot-mode .recordListTable .el-table td,
			body.screenshot-mode .recordListTable .el-table th {
				/* 截图时去掉记录表的单元格边框，避免出现多余的淡色横线/竖线 */
				border-color: transparent !important;
			}

			/* ElementUI 记录表右侧/顶部的伪元素线也去掉，避免额外竖线 */
			body.screenshot-mode .recordListTable .el-table::before,
			body.screenshot-mode .recordListTable .el-table::after {
				background-color: transparent !important;
			}

			/* 基础信息、采购计划信息等主信息表（JNPF-common-table）的网格线也去掉，
			   但不影响“物资需求清单”这种普通 el-table --mini 表格 */
			body.screenshot-mode .JNPF-common-table {
				border: none !important;
				box-shadow: none !important;
			}
			body.screenshot-mode .JNPF-common-table td,
			body.screenshot-mode .JNPF-common-table th {
				border-color: transparent !important;
			}
			body.screenshot-mode .JNPF-common-table::before,
			body.screenshot-mode .JNPF-common-table::after {
				background-color: transparent !important;
			}

			/* 物资需求清单表格：单独高亮边框，保证截图里和原页面一样清晰 */
			body.screenshot-mode .tm-goods-table td,
			body.screenshot-mode .tm-goods-table th {
				border-color: #e4e7ed !important;
			}

			/* 表单区域去掉可能的分隔线 */
			body.screenshot-mode .el-form-item,
			body.screenshot-mode .el-form-item__content,
			body.screenshot-mode .el-form-item__label {
				border: none !important;
				box-shadow: none !important;
				background-image: none !important;
			}

			/* 单选按钮：隐藏小圆点，仅保留文字（不要色块框） */
			body.screenshot-mode .el-radio__input {
				display: none !important;
			}

			body.screenshot-mode .el-radio .el-radio__label {
				border: none !important;
				background-color: transparent !important;
				padding: 0 2px;
				font-weight: 400;
			}

			body.screenshot-mode .el-radio.is-checked .el-radio__label {
				color: #c03639 !important;
				font-weight: 600 !important;
			}

			body.screenshot-mode .el-radio:not(.is-checked) .el-radio__label {
				color: #606266 !important;
				opacity: 1;
			}

			/* 物资清单底部“添加/导入/批量删除”等操作条在截图中隐藏 */
			body.screenshot-mode .input-table-footer-btn {
				display: none !important;
			}

			/* 附件列表在截图模式下的展示优化：避免长文件名重叠 */
			body.screenshot-mode .UploadFile-container .el-upload-list__item-name {
				margin-right: 0 !important;
				white-space: normal !important;
				word-break: break-all !important;
				line-height: 1.4 !important;
			}

			body.screenshot-mode .UploadFile-container .el-upload-list__item {
				align-items: flex-start !important;
			}

			/* 按你给的 CSS：截图时隐藏右侧预览列，左侧内容撑满宽度，textarea 改成淡底色 */
			body.screenshot-mode #app > div > div.main-container.hasTagsView > section > div > div.JNPF-preview-main.flow-form-main > div.JNPF-content > div:nth-child(2) {
				display: none !important;
			}
			body.screenshot-mode #app > div > div.main-container.hasTagsView > section > div > div.JNPF-preview-main.flow-form-main > div.JNPF-content > div:nth-child(1) {
				width: 100% !important;
			}
			body.screenshot-mode textarea {
				background-color: #FBFCFD !important;
			}

			/* 截图时隐藏“流转列表”表格右侧固定的操作列（包含“详情”按钮） */
			body.screenshot-mode .recordListTable .el-table__fixed-right,
			body.screenshot-mode .recordListTable .el-table__fixed-right-patch {
				display: none !important;
			}
			/* 同时隐藏主体表格中的最后一列，避免空白列 */
			body.screenshot-mode .recordListTable table.el-table__header th:last-child,
			body.screenshot-mode .recordListTable table.el-table__body td:last-child {
				display: none !important;
        }
    `;
		document.head.appendChild(style);

		// 创建按钮工具函数（底部按钮）
		function createButton(text, id, color, onClick) {
			const button = document.createElement('button');
			button.textContent = text;
			button.id = id;
			button.classList.add('tm-tool-btn');
			button.style.padding = '10px 20px';
			button.style.backgroundColor = color;
			button.style.color = 'white';
			button.style.border = 'none';
			button.style.borderRadius = '4px';
			button.style.cursor = 'pointer';
			button.style.boxShadow = '0 2px 10px rgba(0, 0, 0, 0.2)';
			button.style.fontSize = '14px';
			button.style.fontWeight = 'bold';
			button.style.transition = 'all 0.2s ease-in-out';
			button.addEventListener('click', onClick);
			return button;
		}

		// 内部供给方式增强函数：把 1/2 映射为中文并拼接
		function enhanceInternalSupplyMethod(procurementMethod) {
			if (procurementMethod !== '内部供给采购') return procurementMethod;

			const internalTypeFormItem = document.querySelector('[prop="internalType"]');
			if (!internalTypeFormItem) return procurementMethod;

			const checkedRadio = internalTypeFormItem.querySelector('label.el-radio.is-checked');
			if (!checkedRadio) return procurementMethod;

			const radioInput = checkedRadio.querySelector('input.el-radio__original');
			const value = radioInput?.value || radioInput?.getAttribute('value');
			if (!value) return procurementMethod;

			let text = '';
			if (value === '1') text = '邀请竞价';
			else if (value === '2') text = '自主开展谈判';
			else text = value;

			return `内部供给采购（${text}）`;
		}

		// 提取申请人和审批完成时间
		async function extractApplicantAndApprovalTime(results) {
			let tab2 = null;
			const tabItems = document.querySelectorAll('.el-tabs__item');
			for (const item of tabItems) {
				if ((item.textContent || '').trim() === '流转列表') {
					tab2 = item;
					break;
				}
			}
			if (!tab2) tab2 = document.querySelector('#tab-2');
			if (!tab2) return;

			const clickEvent = new MouseEvent('click', {
				bubbles: true,
				cancelable: true
			});
			tab2.dispatchEvent(clickEvent);

			const allTabs = document.querySelectorAll('.el-tabs__item');
			allTabs.forEach((tab) => {
				tab.classList.remove('is-active');
				tab.removeAttribute('aria-selected');
				tab.setAttribute('tabindex', '-1');
			});
			tab2.classList.add('is-active');
			tab2.setAttribute('aria-selected', 'true');
			tab2.setAttribute('tabindex', '0');

			const activeBar = document.querySelector('.el-tabs__active-bar');
			if (activeBar) {
				const tabIndex = Array.from(allTabs).indexOf(tab2);
				const tabWidth = tab2.offsetWidth;
				const tabOffset = tab2.offsetLeft;
				activeBar.style.width = tabWidth + 'px';
				activeBar.style.transform = `translateX(${tabOffset}px)`;
			}

			await new Promise((resolve) => setTimeout(resolve, 500));

			try {
				// 申请人：流转列表第一行，第2列
				const applicantRow = document.querySelector(
					'#pane-2 > div > div.tableContainer.recordListTable > div > div.el-table__body-wrapper.is-scrolling-none > table > tbody > tr:nth-child(1)'
				);
				if (applicantRow) {
					const secondTd = applicantRow.querySelector('td:nth-child(2)');
					if (secondTd) {
						const applicantDiv = secondTd.querySelector('div');
						if (applicantDiv) {
							results['申请人'] = applicantDiv.textContent.trim().split('/')[0];
						}
					}
				}

				// 审批完成时间：最后一行，第3列里的日期部分
				const rows = document.querySelectorAll(
					'#pane-2 > div > div.tableContainer.recordListTable > div > div.el-table__body-wrapper.is-scrolling-none > table > tbody > tr'
				);
				if (rows.length > 0) {
					const lastRow = rows[rows.length - 1];
					const timeElement = lastRow.querySelector('td:nth-child(3) > div');
					let approvalDate = timeElement ? timeElement.textContent.trim() : '';
					const match = approvalDate.match(/\d{4}-\d{2}-\d{2}/);
					results['采购审批完成时间'] = match ? match[0] : '';
				}
			} catch (e) {
				console.error('获取申请人或审批时间失败:', e);
			} finally {
				// 切回表单信息 tab
				let formInfoTab = null;
				const tabElements = document.getElementsByClassName('el-tabs__item is-top');
				for (let i = 0; i < tabElements.length; i++) {
					const tab = tabElements[i];
					const tabText = (tab.textContent || '').trim();
					if (tabText.includes('表单信息')) {
						formInfoTab = tab;
						break;
					}
				}

				if (formInfoTab) {
					const clickEventReturn = new MouseEvent('click', {
						bubbles: true,
						cancelable: true
					});
					formInfoTab.dispatchEvent(clickEventReturn);

					const allTabsReturn = document.querySelectorAll('.el-tabs__item');
					allTabsReturn.forEach((tab) => {
						tab.classList.remove('is-active');
						tab.removeAttribute('aria-selected');
						tab.setAttribute('tabindex', '-1');
					});
					formInfoTab.classList.add('is-active');
					formInfoTab.setAttribute('aria-selected', 'true');
					formInfoTab.setAttribute('tabindex', '0');

					const activeBarReturn = document.querySelector('.el-tabs__active-bar');
					if (activeBarReturn) {
						const tabIndexReturn = Array.from(allTabsReturn).indexOf(formInfoTab);
						const tabWidthReturn = formInfoTab.offsetWidth;
						const tabOffsetReturn = formInfoTab.offsetLeft;
						activeBarReturn.style.width = tabWidthReturn + 'px';
						activeBarReturn.style.transform = `translateX(${tabOffsetReturn}px)`;
					}

					await new Promise((resolve) => setTimeout(resolve, 500));
				} else {
					console.error('未找到表单信息标签页，无法返回');
				}
			}
		}

		// 通用工具函数
		async function extractValueAfterDelay(selector, delay) {
			await new Promise((resolve) => setTimeout(resolve, delay));
			const element = document.querySelector(selector);
			return element ? element.value : '';
		}

		function extractValue(selector) {
			const element = document.querySelector(selector);
			return element ? (element.value || '').replace(/[\s\u200B-\u200D\uFEFF]/g, '') : '';
		}

		function extractRadioValue(containerSelector, options) {
			const container = document.querySelector(containerSelector);
			if (!container) return '';
			const labels = container.querySelectorAll('label');
			for (let i = 0; i < labels.length; i++) {
				if (labels[i].classList.contains('is-checked')) {
					return options[i] || '';
				}
			}
			return '';
		}

		function showCopySuccessToast(message) {
			const toast = document.createElement('div');
			toast.className = 'copy-success-toast';
			toast.textContent = message;

			// 获取"创建目录"按钮的位置，使提示框的水平中心与其水平中心对齐
			const createDirBtn = document.getElementById('create-directory-btn');

			if (createDirBtn) {
				const btnRect = createDirBtn.getBoundingClientRect();
				if (btnRect.width > 0 && btnRect.height > 0) {
					// 计算"创建目录"按钮的水平中心位置，并往左偏移一点
					const centerX = btnRect.left + btnRect.width / 2 - 15;
					// 垂直位置在按钮下方一点
					const centerY = btnRect.bottom + 30;

					toast.style.position = 'fixed';
					toast.style.top = centerY + 'px';
					toast.style.left = centerX + 'px';
					toast.style.transform = 'translateX(-50%)';
					toast.style.zIndex = '10000';
				} else {
					// 如果按钮还没有渲染，使用默认位置
					toast.style.position = 'fixed';
					toast.style.top = '200px';
					toast.style.left = '50%';
					toast.style.transform = 'translateX(-50%)';
					toast.style.zIndex = '10000';
				}
			} else {
				// 如果找不到"创建目录"按钮，使用默认居中
				toast.style.position = 'fixed';
				toast.style.top = '200px';
				toast.style.left = '50%';
				toast.style.transform = 'translateX(-50%)';
				toast.style.zIndex = '10000';
			}

			document.body.appendChild(toast);

			setTimeout(() => {
				toast.classList.add('fade-out');
			}, 2000);

			setTimeout(() => {
				if (toast.parentNode) {
					toast.parentNode.removeChild(toast);
				}
			}, 2500);
		}

		// 截图函数：优先截 #app > div > div.main-container.hasTagsView > section，
		// 找不到再尝试 #printdocument，最后兜底 section.app-main
		// 会临时把目标区域以及内部所有滚动容器全部展开，保证可以截到需要下滚才能看到的内容
		async function captureSectionScreenshot() {
			// 用于在截图过程中临时标记“物资需求清单”表格，方便单独美化边框
			let goodsTable = null;

			// 截图前先自动调整所有禁用 textarea 的高度
			autoAdjustDisabledTextareas();
			// 给浏览器一点时间完成重排
			await new Promise((resolve) => setTimeout(resolve, 50));

			// 截图前进入“截图模式”，应用专用美化样式
			document.body.classList.add('screenshot-mode');
			try {
				const selectors = [
					'#app > div > div.main-container.hasTagsView > section',
					'#printdocument',
					'section.app-main'
				];

				let target = null;
				let usedSelector = '';
				let restoredDisplay = null;

				// 记录所有被修改过样式的元素，方便事后还原
				const modifiedNodes = [];

				for (const sel of selectors) {
					const el = document.querySelector(sel);
					if (el) {
						target = el;
						usedSelector = sel;
						break;
					}
				}

				if (!target) {
					console.warn('未找到可截图的区域（main-container / #printdocument / .app-main）');
					showCopySuccessToast('未找到可截图区域');
					document.body.classList.remove('screenshot-mode');
					return;
				}

				// 如果是隐藏的打印区域，临时显示
				if (usedSelector === '#printdocument') {
					const currentDisplay = getComputedStyle(target).display;
					if (currentDisplay === 'none') {
						restoredDisplay = target.style.display;
						target.style.display = 'block';
					}
				}

				// 工具：展开某个元素的高度和 overflow
				function expandElement(el) {
					const style = getComputedStyle(el);
					const overflowY = style.overflowY;
					const overflow = style.overflow;
					const needExpand =
						overflowY === 'auto' ||
						overflowY === 'scroll' ||
						overflow === 'auto' ||
						overflow === 'scroll' ||
						overflow === 'hidden';

					if (!needExpand) return;

					const record = {
						node: el,
						height: el.style.height,
						overflow: el.style.overflow
					};
					modifiedNodes.push(record);

					const sh = el.scrollHeight;
					if (sh && sh > 0) {
						el.style.height = sh + 'px';
					}
					el.style.overflow = 'visible';
				}

				// 展开目标本身
				expandElement(target);

				// 展开内部所有可能有滚动条的容器
				const scrollContainers = target.querySelectorAll('*');
				scrollContainers.forEach((el) => expandElement(el));

				// 遮蔽所有“详情”文字，避免截图中出现（不影响布局）
				const detailNodes = [];
				const detailCandidates = target.querySelectorAll('a, span, button, div');
				detailCandidates.forEach((el) => {
					const text = (el.textContent || '').trim();
					if (text === '详情') {
						detailNodes.push({
							node: el,
							color: el.style.color,
							textShadow: el.style.textShadow
						});
						el.style.color = 'transparent';
						el.style.textShadow = 'none';
					}
				});

				// 标记物资需求清单表格，方便截图样式单独处理
				const footer = document.querySelector('.input-table-footer-btn');
				if (footer && footer.previousElementSibling) {
					const maybeFormItem = footer.previousElementSibling;
					const candidateTable = maybeFormItem.querySelector('.el-table');
					if (candidateTable) {
						goodsTable = candidateTable;
						goodsTable.classList.add('tm-goods-table');
					}
				}

				// 避免滚动影响
				window.scrollTo(0, 0);

				const fullWidth = target.scrollWidth;
				const fullHeight = target.scrollHeight;

				const canvas = await html2canvas(target, {
					scale: 2,
					useCORS: true,
					logging: false,
					width: fullWidth || undefined,
					height: fullHeight || undefined,
					windowWidth: document.documentElement.scrollWidth,
					windowHeight: document.documentElement.scrollHeight
				});

				// 还原样式
				if (restoredDisplay !== null && usedSelector === '#printdocument') {
					target.style.display = restoredDisplay;
				}

				// 还原所有被修改过的节点
				for (const record of modifiedNodes) {
					if (!record.node) continue;
					record.node.style.height = record.height;
					record.node.style.overflow = record.overflow;
				}

				// 还原“详情”文字样式
				for (const record of detailNodes) {
					if (!record.node) continue;
					record.node.style.color = record.color;
					record.node.style.textShadow = record.textShadow;
				}

				// 移除物资需求清单的标记 class
				if (goodsTable && goodsTable.classList.contains('tm-goods-table')) {
					goodsTable.classList.remove('tm-goods-table');
				}

				const dataURL = canvas.toDataURL('image/png');
				const link = document.createElement('a');
				const now = new Date();
				const fileName = `采购页面截图_${now.getFullYear()}-${now.getMonth() + 1}-${now.getDate()}.png`;
				link.href = dataURL;
				link.download = fileName;
				document.body.appendChild(link);
				link.click();
				document.body.removeChild(link);

				console.log('截图已生成并触发下载：', fileName);
			} catch (e) {
				console.error('截图失败：', e);
				showCopySuccessToast('截图失败，请查看控制台');
			} finally {
				// 退出截图模式
				document.body.classList.remove('screenshot-mode');
			}
		}

		// 创建下方按钮（与上方按钮一样采用延时创建 + 打印隐藏）
		function createButtons() {
			// 提取采购信息按钮
			const extractButton = createButton('提取采购信息', 'extract-purchase-info-btn', '#409eff', async function () {
				try {
					console.clear();

					const currentUrl = window.location.href;
					let pageType = 'unknown';
					if (currentUrl.includes('/flowTodo')) pageType = 'flowTodo';
					else if (currentUrl.includes('/flowDone')) pageType = 'flowDone';
					else if (currentUrl.includes('/purchasedemand')) pageType = 'purchasedemand';

					const fieldOrder = [
						'是否',
						'是否本周',
						'成本费用列支',
						'申请部门',
						'申请人',
						'申请人电话',
						'项目名称',
						'内部编号',
						'采购审批完成时间',
						'月份',
						'项目类型',
						'采购模式',
						'采购方式',
						'预估金额（元）'
					];

					const results = {};

					results['是否'] = '否';
					results['是否本周'] =
						'=IF(AND([@采购审批完成时间]>=TODAY()-WEEKDAY(TODAY(),2)+1,[@采购审批完成时间]<=TODAY()-WEEKDAY(TODAY(),2)+7),"是","否")';

					// 成本费用列支
					let costValue = '';
					const primaryCostElement = document.querySelector('[for="amountSource"]+ div input');
					if (primaryCostElement && primaryCostElement.value) {
						costValue = primaryCostElement.value;
					} else {
						const amountSourceDiv = document.querySelector('div.amountSource');
						if (amountSourceDiv && amountSourceDiv.textContent) {
							costValue = amountSourceDiv.textContent.trim();
						} else {
							const costElements = document.querySelectorAll('input[placeholder="请输入项目名称"]');
							costValue = costElements.length > 1 ? costElements[1].value : '';
						}
					}
					costValue = costValue.replace(/[\s\u200B-\u200D\uFEFF]/g, '');
					results['成本费用列支'] = costValue;

					// 申请人、审批完成时间
					await extractApplicantAndApprovalTime(results);

					// 申请部门、电话
					results['申请部门'] =
						'=IF([@申请人]="","未找到对应部门",XLOOKUP([@申请人],人员名单及部门列表!A:A,人员名单及部门列表!B:B,"未找到对应部门",0))';
					results['申请人电话'] =
						'=XLOOKUP([@申请人],人员名单及部门列表!A:A,人员名单及部门列表!C:C)';

					// 项目名称
					let projectName = '';
					const primaryProjectElement = document.querySelector('[for="projectName"]+ div input');
					if (primaryProjectElement && primaryProjectElement.value) {
						projectName = primaryProjectElement.value;
					} else {
						projectName = extractValue(
							'#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(3) > div > div > div > input'
						);
					}
					results['项目名称'] = projectName;

					// 内部编号
					let internalId = '';
					const primaryInternalIdElement = document.querySelector('[for="orgInnerCode"]+ div input');
					if (primaryInternalIdElement && primaryInternalIdElement.value) {
						internalId = primaryInternalIdElement.value;
					} else {
						const internalIdElement = document.querySelector('input[placeholder="公司内部编号"]');
						internalId = internalIdElement ? internalIdElement.value : '';
					}
					let internalId_wrapper = document.querySelector('[prop="serialNo"]');
					let internalId_input = internalId_wrapper
						? internalId_wrapper.querySelector('input.el-input__inner')
						: null;
					let internalId_val = internalId_input ? internalId_input.value : null;
					internalId = internalId_val;

					results['内部编号'] = internalId && internalId.trim() !== '' ? internalId.trim() : '无';

					// 月份
					results['月份'] = '=TEXT(MONTH([@采购审批完成时间]),"00")';

					// 项目类型
					let projectType = '';
					const primaryProjectTypeElement = document.querySelector(
						'label[for="projectType"] + .el-form-item__content .el-radio.is-checked .el-radio__label'
					);
					if (primaryProjectTypeElement && primaryProjectTypeElement.textContent) {
						projectType = primaryProjectTypeElement.textContent.trim();
					} else {
						projectType = extractRadioValue(
							'#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(7) > div > div > div > div',
							['货物类', '服务类', '工程类']
						);
					}
					results['项目类型'] = projectType;

					// 采购模式
					let purchaseMode = '';
					const primaryPurchaseModeElement = document.querySelector(
						'label[for="purchaseType"] + div .is-checked .el-radio__label'
					);
					if (primaryPurchaseModeElement && primaryPurchaseModeElement.textContent) {
						purchaseMode = primaryPurchaseModeElement.textContent.trim();
					} else {
						purchaseMode = extractRadioValue(
							'#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(6) > div > div > div > div',
							['框架', '专项']
						);
					}
					results['采购模式'] = purchaseMode;

					// 采购方式（从 prop="purchaseWay" 的 el-select 中读取）
					let procurementMethod = '';

					// 1. 优先从 prop="purchaseWay" 下拉框当前选中值读取
					const purchaseWayFormItem = document.querySelector('[prop="purchaseWay"]');
					if (purchaseWayFormItem) {
						const purchaseInput = purchaseWayFormItem.querySelector(
							'.el-form-item__content .el-select .el-input__inner'
						);
						if (purchaseInput && purchaseInput.value) {
							procurementMethod = purchaseInput.value.trim();
						}
					}

					// 2. 如果没取到，再做一次兜底
					if (!procurementMethod) {
						const fallbackInput = document.querySelector(
							'.el-form-item[prop="purchaseWay"] .el-input__inner'
						);
						if (fallbackInput && fallbackInput.value) {
							procurementMethod = fallbackInput.value.trim();
						}
					}

					// 3. 内部供给方式增强（如：内部供给采购（邀请竞价））
					procurementMethod = enhanceInternalSupplyMethod(procurementMethod);

					// 4. 其它映射
					if (procurementMethod === '沿用框招结果') procurementMethod = '框架内采购';
					if (procurementMethod === '电商化采购') procurementMethod = '电子商城采购';

					results['采购方式'] = procurementMethod;

					// 预估金额
					const estimatedAmountElement = document.querySelector(
						'div[prop="estimatedAmount"] > div.el-form-item__content > div.el-input > input'
					);
					let estimatedAmount = estimatedAmountElement?.value || '';
					if (!estimatedAmount) {
						const backupElement = document.querySelector(
							'#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(24) > div > div > div > input'
						);
						estimatedAmount = backupElement?.value || '';
					}
					results['预估金额（元）'] = estimatedAmount;

					// 控制台输出
					console.log('=============== 采购信息提取结果 ===============');
					console.log(`当前页面类型: ${pageType}`);
					fieldOrder.forEach((field) => {
						console.log(`${field}：${results[field] || '未获取到值'}`);
					});
					console.log('=============================================');

					// 复制到剪贴板（按顺序拼接）
					const resultString = fieldOrder.map((f) => results[f] || '').join('\t');
					GM_setClipboard(resultString, 'text');

					showCopySuccessToast('采购信息已复制到剪贴板');
					extractedData = results;

					console.log('============ 复制到剪贴板的文本顺序 =============');
					console.log('字段顺序：', fieldOrder.join('\t'));
					console.log('文本内容：', resultString);
					console.log('=============================================');
				} catch (error) {
					console.error('提取信息时出错:', error);
				}
			});

			// 创建目录按钮
			const createDirButton = createButton('创建目录', 'create-directory-btn', '#67c23a', async function () {
				try {
					const currentData = {};

					// 申请人、审批时间
					await extractApplicantAndApprovalTime(currentData);

					// 项目名称
					let projectName = '';
					const primaryProjectElement = document.querySelector('[for="projectName"]+ div input');
					if (primaryProjectElement && primaryProjectElement.value) {
						projectName = primaryProjectElement.value;
					} else {
						projectName = extractValue(
							'#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(3) > div > div > div > input'
						);
					}
					currentData['项目名称'] = projectName;

					// 内部编号
					let internalId = '';
					const primaryInternalIdElement = document.querySelector('[for="orgInnerCode"]+ div input');
					if (primaryInternalIdElement && primaryInternalIdElement.value) {
						internalId = primaryInternalIdElement.value;
					} else {
						const internalIdElement = document.querySelector('input[placeholder="公司内部编号"]');
						internalId = internalIdElement ? internalIdElement.value : '';
					}
					let internalId_wrapper = document.querySelector('[prop="serialNo"]');
					let internalId_input = internalId_wrapper
						? internalId_wrapper.querySelector('input.el-input__inner')
						: null;
					let internalId_val = internalId_input ? internalId_input.value : null;
					internalId = internalId_val;
					currentData['内部编号'] = internalId && internalId.trim() !== '' ? internalId.trim() : '无';

					// 采购方式（从 prop="purchaseWay" 的 el-select 中读取）
					let procurementMethod = '';

					const purchaseWayFormItem2 = document.querySelector('[prop="purchaseWay"]');
					if (purchaseWayFormItem2) {
						const purchaseInput2 = purchaseWayFormItem2.querySelector(
							'.el-form-item__content .el-select .el-input__inner'
						);
						if (purchaseInput2 && purchaseInput2.value) {
							procurementMethod = purchaseInput2.value.trim();
						}
					}

					if (!procurementMethod) {
						const fallbackInput2 = document.querySelector(
							'.el-form-item[prop="purchaseWay"] .el-input__inner'
						);
						if (fallbackInput2 && fallbackInput2.value) {
							procurementMethod = fallbackInput2.value.trim();
						}
					}

					procurementMethod = enhanceInternalSupplyMethod(procurementMethod);

					if (procurementMethod === '沿用框招结果') procurementMethod = '框架内采购';
					if (procurementMethod === '电商化采购') procurementMethod = '电子商城采购';
					currentData['采购方式'] = procurementMethod;

					const applicant = currentData['申请人'];
					const approvalDate = currentData['采购审批完成时间'];
					projectName = currentData['项目名称'];
					internalId = currentData['内部编号'];

					let procurementMethodForDir = procurementMethod;

					let directoryText;
					if (procurementMethodForDir === '零星采购') {
						directoryText = `${procurementMethodForDir} - - ${internalId} - - ${approvalDate} - - ${projectName} - - ${applicant}`;
					} else {
						directoryText = `${procurementMethodForDir} - - ${approvalDate} - - ${internalId} - - ${projectName} - - ${applicant}`;
					}

					GM_setClipboard(directoryText, 'text');
					showCopySuccessToast('目录文本已复制到剪贴板');

					console.log('=============== 创建的目录文本 ===============');
					console.log(directoryText);
					console.log('=============================================');
				} catch (error) {
					console.error('创建目录时出错:', error);
				}
			});

			// 截图按钮
			const captureButton = createButton('截图', 'capture-screenshot-btn', '#f39c12', captureSectionScreenshot);

			// 添加到DOM（CSS已确保按钮宽度和高度一致）
			buttonContainer.appendChild(extractButton);
			buttonContainer.appendChild(createDirButton);
			buttonContainer.appendChild(captureButton);
			document.body.appendChild(buttonContainer);

			// 对齐第二行按钮容器的位置
			setTimeout(() => {
				// 获取第一行按钮容器
				const firstRowContainer = document.getElementById('first-row-button-container');
				if (firstRowContainer) {
					// 获取第一行按钮容器的位置
					const firstRowRect = firstRowContainer.getBoundingClientRect();
					// 设置第二行按钮容器与第一行对齐
					buttonContainer.style.left = firstRowRect.left + 'px';
					buttonContainer.style.transform = 'none';
				}
			}, 100);
		}

		// 等待页面加载完成后创建按钮（与上方按钮一致）
		if (document.readyState === 'complete' || document.readyState === 'interactive') {
			setTimeout(createButtons, 1200);
		} else {
			document.addEventListener('DOMContentLoaded', function () {
				setTimeout(createButtons, 1200);
			});
		}
	}

	// ---------------- 企信：样式切换器（保留原功能） ----------------
	function initQXStyleToggleTools() {
		// 检查样式是否已应用的存储键
		const STYLE_APPLIED_KEY = 'custom_style_applied';
		const HIGHLIGHT_APPLIED_KEY = 'highlight_applied';
		const AUTO_COPY_ENABLED_KEY = 'auto_copy_enabled';

		// 自定义样式
		const customStyle = `
        .el-radio.is-checked .el-radio__label {
            color: red !important;
            font-weight: bold !important;
            background-color: lightgreen !important;
            padding: 2px 6px 2px 2px !important;
            border-radius: 4px !important;
        }
    `;

		// 创建样式元素
		let styleElement = null;

		// 目标 input 元素的选择器
		const inputSelector =
			'input[type="text"][disabled="disabled"][readonly="readonly"].el-input__inner[placeholder="请选择采购方式"]';

		// 创建一个 MutationObserver 实例
		const observer = new MutationObserver((mutations) => {
			mutations.forEach((mutation) => {
				if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
					for (const node of mutation.addedNodes) {
						// 检查新添加的节点是否包含目标 input 元素
						if (node.nodeType === Node.ELEMENT_NODE && node.querySelector(inputSelector)) {
							processInput();
							return; // 找到目标，立即返回，避免重复处理
						}
					}
				}
			});
		});

		// 创建按钮容器
		const buttonContainer = document.createElement('div');
		buttonContainer.id = 'first-row-button-container';
		buttonContainer.style.position = 'fixed';
		buttonContainer.style.top = '70px';
		// 与下方"提取采购信息 / 创建目录"按钮容器保持同一水平中心
		buttonContainer.style.left = '53%';
		buttonContainer.style.transform = 'translateX(-50%)';
		buttonContainer.style.zIndex = '9999';
		buttonContainer.style.display = 'flex';
		buttonContainer.style.gap = '20px';

		// 添加打印隐藏样式（hover 特效复用全局 .tm-tool-btn）
		const style = document.createElement('style');
		style.textContent = `
        @media print {
            #adjust-height-btn,
            #toggle-style-btn,
            #toggle-auto-copy-btn {
                display: none !important;
            }
        }
    `;
		document.head.appendChild(style);

		// 辅助函数：创建按钮（上方按钮）
		function createButton(text, id, color, onClick) {
			const button = document.createElement('button');
			button.textContent = text;
			button.id = id;
			button.classList.add('tm-tool-btn');
			button.style.padding = '10px 20px';
			button.style.backgroundColor = color;
			button.style.color = 'white';
			button.style.border = 'none';
			button.style.borderRadius = '4px';
			button.style.cursor = 'pointer';
			button.style.boxShadow = '0 2px 10px rgba(0, 0, 0, 0.2)';
			button.style.fontSize = '14px';
			button.style.fontWeight = 'bold';
			button.style.transition = 'all 0.2s ease-in-out';
			button.addEventListener('click', onClick);
			return button;
		}

		// 调整文本区域高度（企信页用）
		function adjustTextareas() {
			autoAdjustDisabledTextareas();
		}

		// 处理输入框高亮功能
		function processInput() {
			// 获取目标 input 元素
			const inputElement = document.querySelector(inputSelector);

			if (inputElement) {
				console.log('找到目标 input 元素:', inputElement);
				// 获取 el-select 组件的父元素
				const elSelect = inputElement.closest('.el-select');
				if (!elSelect) {
					console.error('找不到 el-select 组件');
					return;
				}

				// 模拟点击 el-select，展开下拉菜单
				elSelect.click();

				// 短暂延迟后，查找选中的 span 元素
				setTimeout(() => {
					// 查找下拉菜单中带有 selected 类的 li 元素下的 span
					const selectedSpan = elSelect.querySelector('.el-select-dropdown__item.selected > span');
					let inputValue = '';

					if (selectedSpan) {
						inputValue = selectedSpan.textContent.trim();
					}

					// 移除之前的 span 元素，避免重复添加
					const existingSpan = inputElement.nextElementSibling;
					if (existingSpan && existingSpan.classList.contains('highlighted-text')) {
						existingSpan.remove();
						inputElement.style.display = ''; // 恢复显示
					}

					// 创建一个 span 元素来包裹文字并添加背景色
					const span = document.createElement('span');
					span.classList.add('highlighted-text');
					span.textContent = inputValue;

					// 隐藏 input 元素，并将 span 元素插入到 input 元素后面，模拟文字高亮效果
					inputElement.style.display = 'none';
					inputElement.parentNode.insertBefore(span, inputElement.nextSibling);

					// 设置 span 元素的样式
					span.style.backgroundColor = 'lightgreen';
					span.style.padding = '0 2px';
					span.style.borderRadius = '3px';
					span.style.font = window.getComputedStyle(inputElement).font;
					span.style.color = 'red';
					span.style.fontSize = '16px';
					span.style.fontWeight = 'bold';
					span.style.position = 'relative';
					span.style.left = '31%';
					span.style.top = '0px';
					span.style.whiteSpace = 'nowrap';

					// 再次点击 el-select，关闭下拉菜单
					elSelect.click();
				}, 2000);
			}
		}

		// 应用样式
		function applyStyle() {
			if (!styleElement) {
				styleElement = document.createElement('style');
				styleElement.id = 'custom-radio-style';
				styleElement.textContent = customStyle;
				document.head.appendChild(styleElement);
			}
		}

		// 移除样式
		function removeStyle() {
			if (styleElement) {
				styleElement.remove();
				styleElement = null;
			}
		}

		// 更新按钮状态（保留通用 tm-tool-btn class，避免被全局开关漏掉）
		function updateButtonState(button, isStyleApplied, isHighlightApplied) {
			let text = '应用';
			let backgroundColor = '#67c23a';
			let stateClass = 'green-state';

			if (isStyleApplied || isHighlightApplied) {
				text = '取消';
				backgroundColor = '#f44336';
				stateClass = 'red-state';
			}

			button.textContent = text + '样式';
			button.style.backgroundColor = backgroundColor;

			// 只切换状态相关 class，不覆盖 tm-tool-btn
			button.classList.remove('green-state', 'red-state');
			button.classList.add(stateClass);
		}

		// 自动复制功能处理
		let autoCopyEnabled = false;
		let mouseUpHandler = null;
		let lastCopiedText = ''; // 防止重复复制相同内容
		let copyTimer = null; // 防抖计时器

		function enableAutoCopy() {
			if (mouseUpHandler) return; // 已启用，避免重复绑定

			// 使用mouseup事件触发复制
			mouseUpHandler = function (e) {
				// 清除之前的计时器
				if (copyTimer) {
					clearTimeout(copyTimer);
				}

				// 增加延迟，确保Vue组件中的选择已完成
				copyTimer = setTimeout(() => {
					try {
						let textToCopy = '';
						const target = e.target;

						// 辅助函数：从input或textarea元素中获取文本
						function getTextFromInputElement(element) {
							if (!element || (element.tagName !== 'INPUT' && element.tagName !== 'TEXTAREA')) {
								return '';
							}

							const inputValue = element.value || '';
							if (!inputValue || inputValue.trim().length === 0) {
								return '';
							}

							// 优先尝试通过selectionStart和selectionEnd获取选中的文本
							if (element.selectionStart !== undefined && element.selectionEnd !== undefined) {
								const start = element.selectionStart;
								const end = element.selectionEnd;
								if (start !== end && start < end && start >= 0 && end <= inputValue.length) {
									// 有部分文本被选中，返回选中的部分
									const selectedText = inputValue.substring(start, end);
									if (selectedText.trim().length > 0) {
										return selectedText.trim();
									}
								}
							}

							// 尝试通过window.getSelection()获取（对于某些情况可能有效）
							const selection = window.getSelection();
							if (selection) {
								const selectedText = selection.toString().trim();
								if (selectedText && selectedText.length > 0) {
									// 验证选中的文本是否来自当前input/textarea
									const range = selection.rangeCount > 0 ? selection.getRangeAt(0) : null;
									if (range) {
										const container = range.commonAncestorContainer;
										let checkElement = container.nodeType === Node.TEXT_NODE ? container.parentElement : container;
										while (checkElement && checkElement !== document.body) {
											if (checkElement === element) {
												return selectedText;
											}
											checkElement = checkElement.parentElement;
										}
									}
								}
							}

							// 如果无法获取选中部分，返回整个value
							return inputValue.trim();
						}

						// 优先处理：检查点击的元素是否是input或textarea（包括disabled的）
						if (target && (target.tagName === 'INPUT' || target.tagName === 'TEXTAREA')) {
							textToCopy = getTextFromInputElement(target);
						} else {
							// 处理普通文本选择
							const selection = window.getSelection();
							if (selection) {
								textToCopy = selection.toString().trim();
							}

							// 如果selection没有获取到文本，尝试从点击的元素中查找input或textarea
							if (!textToCopy || textToCopy.length === 0) {
								// 查找点击位置附近的input或textarea元素
								let element = target;
								let depth = 0;
								const maxDepth = 8; // 增加查找深度

								while (element && depth < maxDepth) {
									// 检查当前元素是否是input或textarea
									const textFromCurrent = getTextFromInputElement(element);
									if (textFromCurrent) {
										textToCopy = textFromCurrent;
										break;
									}

									// 检查子元素中是否有input或textarea
									const childInput = element.querySelector('input, textarea');
									if (childInput) {
										const textFromChild = getTextFromInputElement(childInput);
										if (textFromChild) {
											textToCopy = textFromChild;
											break;
										}
									}

									element = element.parentElement;
									depth++;
								}
							}
						}

						// 检查是否有文本需要复制，且与上次复制的不同
						if (textToCopy && textToCopy.length > 0 && textToCopy !== lastCopiedText) {
							GM_setClipboard(textToCopy, 'text');
							lastCopiedText = textToCopy;
							// 可以显示一个简短的提示，但不打断用户操作
							console.log('已自动复制选中文本:', textToCopy.substring(0, 50) + (textToCopy.length > 50 ? '...' : ''));
						}
					} catch (err) {
						console.error('自动复制出错:', err);
					}
				}, 200); // 延迟200ms，确保Vue的选择已完成
			};

			// 使用捕获阶段，确保能够捕获到事件（在Vue处理之前）
			document.addEventListener('mouseup', mouseUpHandler, true);
			console.log('自动复制功能已启用');
		}

		function disableAutoCopy() {
			if (mouseUpHandler) {
				document.removeEventListener('mouseup', mouseUpHandler, true);
				mouseUpHandler = null;
			}
			if (copyTimer) {
				clearTimeout(copyTimer);
				copyTimer = null;
			}
			lastCopiedText = ''; // 重置上次复制的内容
			console.log('自动复制功能已禁用');
		}

		function updateAutoCopyButtonState(button, enabled) {
			if (enabled) {
				button.textContent = '关闭自动复制';
				button.style.backgroundColor = '#67c23a';
			} else {
				button.textContent = '开启自动复制';
				button.style.backgroundColor = '#909399';
			}
		}

		// 创建按钮
		function createButtons() {

			// 1. 创建"调整高度"按钮
			const adjustHeightButton = createButton('调整高度', 'adjust-height-btn', '#409eff', adjustTextareas);

			// 2. 创建"样式切换"按钮
			const toggleStyleButton = createButton('应用样式', 'toggle-style-btn', '#67c23a', function () {
				// 初始化状态
				let isStyleApplied = GM_getValue(STYLE_APPLIED_KEY, false);
				let isHighlightApplied = GM_getValue(HIGHLIGHT_APPLIED_KEY, false);

				// 切换状态
				isStyleApplied = !isStyleApplied;
				isHighlightApplied = !isHighlightApplied;

				// 保存状态
				GM_setValue(STYLE_APPLIED_KEY, isStyleApplied);
				GM_setValue(HIGHLIGHT_APPLIED_KEY, isHighlightApplied);

				updateButtonState(toggleStyleButton, isStyleApplied, isHighlightApplied);

				// 应用/移除样式
				if (isStyleApplied) {
					applyStyle();
				} else {
					removeStyle();
				}

				// 启动/停止监听高亮
				if (isHighlightApplied) {
					observer.observe(document.body, {
						childList: true,
						subtree: true
					});
					processInput();
				} else {
					observer.disconnect();
					const inputElement = document.querySelector(inputSelector);
					if (inputElement) {
						const existingSpan = inputElement.nextElementSibling;
						if (existingSpan && existingSpan.classList.contains('highlighted-text')) {
							existingSpan.remove();
							inputElement.style.display = ''; // 恢复显示
						}
					}
				}
			});

			// 初始化样式切换按钮状态
			let isStyleApplied = GM_getValue(STYLE_APPLIED_KEY, false);
			let isHighlightApplied = GM_getValue(HIGHLIGHT_APPLIED_KEY, false);

			updateButtonState(toggleStyleButton, isStyleApplied, isHighlightApplied);

			if (isStyleApplied) {
				applyStyle();
			}
			if (isHighlightApplied) {
				observer.observe(document.body, {
					childList: true,
					subtree: true
				});
			}

			// 3. 创建"自动复制"按钮
			const toggleAutoCopyButton = createButton('开启自动复制', 'toggle-auto-copy-btn', '#909399', function () {
				autoCopyEnabled = !autoCopyEnabled;
				GM_setValue(AUTO_COPY_ENABLED_KEY, autoCopyEnabled);

				updateAutoCopyButtonState(toggleAutoCopyButton, autoCopyEnabled);

				if (autoCopyEnabled) {
					enableAutoCopy();
				} else {
					disableAutoCopy();
				}
			});

			// 初始化自动复制按钮状态
			autoCopyEnabled = GM_getValue(AUTO_COPY_ENABLED_KEY, false);
			updateAutoCopyButtonState(toggleAutoCopyButton, autoCopyEnabled);
			if (autoCopyEnabled) {
				enableAutoCopy();
			}

			// 将按钮添加到容器（关闭自动复制移到第一个）
			buttonContainer.appendChild(toggleAutoCopyButton);
			buttonContainer.appendChild(adjustHeightButton);
			buttonContainer.appendChild(toggleStyleButton);

			// 将容器添加到页面
			document.body.appendChild(buttonContainer);

			// 在第一行按钮上方创建切换隐藏按钮（与"取消样式"按钮对齐，宽高一致）
			let toolsHiddenCenter = false;
			const toggleVisibilityCenterBtn = document.createElement('button');
			toggleVisibilityCenterBtn.id = 'tm-toggle-tools-visibility-btn-center';
			toggleVisibilityCenterBtn.textContent = '隐藏工具';
			toggleVisibilityCenterBtn.classList.add('tm-tool-btn');
			toggleVisibilityCenterBtn.style.position = 'fixed';
			toggleVisibilityCenterBtn.style.top = '20px';
			toggleVisibilityCenterBtn.style.zIndex = '9999';
			// 与第一行按钮样式保持一致
			toggleVisibilityCenterBtn.style.padding = '10px 20px';
			toggleVisibilityCenterBtn.style.backgroundColor = '#909399';
			toggleVisibilityCenterBtn.style.color = '#fff';
			toggleVisibilityCenterBtn.style.border = 'none';
			toggleVisibilityCenterBtn.style.borderRadius = '4px';
			toggleVisibilityCenterBtn.style.cursor = 'pointer';
			toggleVisibilityCenterBtn.style.boxShadow = '0 2px 10px rgba(0, 0, 0, 0.2)';
			toggleVisibilityCenterBtn.style.fontSize = '14px';
			toggleVisibilityCenterBtn.style.fontWeight = 'bold';
			toggleVisibilityCenterBtn.style.transition = 'all 0.2s ease-in-out';

			toggleVisibilityCenterBtn.addEventListener('click', () => {
				toolsHiddenCenter = !toolsHiddenCenter;

				const allToolButtons = document.querySelectorAll('.tm-tool-btn');
				allToolButtons.forEach((btn) => {
					// 不隐藏自己
					if (btn === toggleVisibilityCenterBtn) return;
					// 不隐藏左上角的切换按钮
					if (btn.id === 'tm-toggle-tools-visibility-btn') return;
					// 只控制脚本自己加的工具按钮
					if (toolsHiddenCenter) {
						btn.dataset._tm_prevDisplay = btn.style.display || '';
						btn.style.display = 'none';
					} else {
						btn.style.display = btn.dataset._tm_prevDisplay || '';
					}
				});

				toggleVisibilityCenterBtn.textContent = toolsHiddenCenter ? '显示工具' : '隐藏工具';
			});

			document.body.appendChild(toggleVisibilityCenterBtn);

			// 对齐函数：获取"调整高度"按钮的位置，使切换隐藏按钮与其水平对齐
			function alignToggleButton() {
				const adjustHeightBtn = document.getElementById('adjust-height-btn');
				if (adjustHeightBtn) {
					const rect = adjustHeightBtn.getBoundingClientRect();
					if (rect.width > 0 && rect.height > 0) {
						toggleVisibilityCenterBtn.style.left = rect.left + 'px';
						toggleVisibilityCenterBtn.style.transform = 'none';
						return true; // 对齐成功
					}
				}
				return false; // 对齐失败
			}

			// 使用requestAnimationFrame确保在渲染后对齐
			const alignAfterRender = () => {
				requestAnimationFrame(() => {
					if (!alignToggleButton()) {
						// 如果对齐失败，继续尝试
						setTimeout(alignAfterRender, 50);
					}
				});
			};

			// 立即尝试对齐
			alignAfterRender();
			// 额外尝试，确保在按钮完全渲染后对齐
			setTimeout(alignAfterRender, 200);
			setTimeout(alignAfterRender, 400);
		}

		// 等待页面加载完成后创建按钮
		if (document.readyState === 'complete' || document.readyState === 'interactive') {
			setTimeout(createButtons, 1200);
		} else {
			document.addEventListener('DOMContentLoaded', function () {
				setTimeout(createButtons, 1200);
			});
		}
	}
})();
