// ==UserScript==
// @name         企信-采购信息提取工具
// @namespace    http://tampermonkey.net/
// @version      2.1
// @description  提取采购信息（采购方式从 purchaseWay 下拉框读取）
// @author       You
// @match        https://qx.ynydtk.cn:8443/buyv2/*
// @grant        GM_setClipboard
// @run-at       document-end
// ==/UserScript==

(function () {
    "use strict";

    // 如果未来不再使用延时选择器，可以删除这两个常量及 extractValueAfterDelay
    const delayedInputSelector =
        '#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(4) > div > div > div > div.el-input.el-input--small.is-disabled.el-input--suffix > input';
    const delayDuration = 2000;

    let extractedData = null;

    const buttonContainer = document.createElement("div");
    buttonContainer.id = "purchase-info-button-container";
    buttonContainer.style.position = "fixed";
    buttonContainer.style.top = "120px";
    buttonContainer.style.left = "53%";
    buttonContainer.style.transform = "translateX(-50%)";
    buttonContainer.style.zIndex = "9999";
    buttonContainer.style.display = "flex";
    buttonContainer.style.gap = "20px";

    const style = document.createElement("style");
    style.textContent = `
        @media print {
            #purchase-info-button-container,
            button#extract-purchase-info-btn,
            button#create-directory-btn {
                display: none !important;
                visibility: hidden !important;
                opacity: 0 !important;
                position: absolute !important;
                left: -9999px !important;
                top: -9999px !important;
            }
        }

        #extract-purchase-info-btn:hover {
            background-color: #66b1ff !important;
            transform: translateY(-2px);
            box-shadow: 0 4px 14px rgba(0, 0, 0, 0.25) !important;
        }
        #extract-purchase-info-btn:active {
            background-color: #3a8ee6 !important;
            transform: translateY(0);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2) !important;
        }

        #create-directory-btn:hover {
            background-color: #85ce61 !important;
            transform: translateY(-2px);
            box-shadow: 0 4px 14px rgba(0, 0, 0, 0.25) !important;
        }
        #create-directory-btn:active {
            background-color: #5daf34 !important;
            transform: translateY(0);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2) !important;
        }

        .copy-success-toast {
            position: fixed;
            top: 200px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #67c23a;
            color: white;
            padding: 12px 24px;
            border-radius: 6px;
            font-size: 14px;
            font-weight: bold;
            z-index: 10000;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            opacity: 1;
            transition: opacity 0.5s ease-out;
        }
        .copy-success-toast.fade-out {
            opacity: 0;
        }
    `;
    document.head.appendChild(style);

    // 提取采购信息按钮
    const extractButton = createButton("提取采购信息", "extract-purchase-info-btn", "#409eff", async function () {
        try {
            console.clear();

            const currentUrl = window.location.href;
            let pageType = "unknown";
            if (currentUrl.includes("/flowTodo")) pageType = "flowTodo";
            else if (currentUrl.includes("/flowDone")) pageType = "flowDone";
            else if (currentUrl.includes("/purchasedemand")) pageType = "purchasedemand";

            const fieldOrder = [
                "是否",
                "是否本周",
                "成本费用列支",
                "申请部门",
                "申请人",
                "申请人电话",
                "项目名称",
                "内部编号",
                "采购审批完成时间",
                "月份",
                "项目类型",
                "采购模式",
                "采购方式",
                "预估金额（元）"
            ];

            const results = {};

            results["是否"] = "否";
            results["是否本周"] =
                '=IF(AND([@采购审批完成时间]>=TODAY()-WEEKDAY(TODAY(),2)+1,[@采购审批完成时间]<=TODAY()-WEEKDAY(TODAY(),2)+7),"是","否")';

            // 成本费用列支
            let costValue = "";
            const primaryCostElement = document.querySelector('[for="amountSource"]+ div input');
            if (primaryCostElement && primaryCostElement.value) {
                costValue = primaryCostElement.value;
            } else {
                const amountSourceDiv = document.querySelector("div.amountSource");
                if (amountSourceDiv && amountSourceDiv.textContent) {
                    costValue = amountSourceDiv.textContent.trim();
                } else {
                    const costElements = document.querySelectorAll('input[placeholder="请输入项目名称"]');
                    costValue = costElements.length > 1 ? costElements[1].value : "";
                }
            }
            costValue = costValue.replace(/[\s\u200B-\u200D\uFEFF]/g, "");
            results["成本费用列支"] = costValue;

            // 申请人、审批完成时间
            await extractApplicantAndApprovalTime(results);

            // 申请部门、电话
            results["申请部门"] =
                '=IF([@申请人]="","未找到对应部门",XLOOKUP([@申请人],人员名单及部门列表!A:A,人员名单及部门列表!B:B,"未找到对应部门",0))';
            results["申请人电话"] =
                "=XLOOKUP([@申请人],人员名单及部门列表!A:A,人员名单及部门列表!C:C)";

            // 项目名称
            let projectName = "";
            const primaryProjectElement = document.querySelector('[for="projectName"]+ div input');
            if (primaryProjectElement && primaryProjectElement.value) {
                projectName = primaryProjectElement.value;
            } else {
                projectName = extractValue(
                    "#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(3) > div > div > div > input"
                );
            }
            results["项目名称"] = projectName;

            // 内部编号
            let internalId = "";
            const primaryInternalIdElement = document.querySelector('[for="orgInnerCode"]+ div input');
            if (primaryInternalIdElement && primaryInternalIdElement.value) {
                internalId = primaryInternalIdElement.value;
            } else {
                const internalIdElement = document.querySelector('input[placeholder="公司内部编号"]');
                internalId = internalIdElement ? internalIdElement.value : "";
            }
            let internalId_wrapper = document.querySelector('[prop="serialNo"]');
            let internalId_input = internalId_wrapper
                ? internalId_wrapper.querySelector("input.el-input__inner")
                : null;
            let internalId_val = internalId_input ? internalId_input.value : null;
            internalId = internalId_val;

            results["内部编号"] =
                internalId && internalId.trim() !== "" ? internalId.trim() : "无";

            // 月份
            results["月份"] = '=TEXT(MONTH([@采购审批完成时间]),"00")';

            // 项目类型
            let projectType = "";
            const primaryProjectTypeElement = document.querySelector(
                'label[for="projectType"] + .el-form-item__content .el-radio.is-checked .el-radio__label'
            );
            if (primaryProjectTypeElement && primaryProjectTypeElement.textContent) {
                projectType = primaryProjectTypeElement.textContent.trim();
            } else {
                projectType = extractRadioValue(
                    "#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(7) > div > div > div > div",
                    ["货物类", "服务类", "工程类"]
                );
            }
            results["项目类型"] = projectType;

            // 采购模式
            let purchaseMode = "";
            const primaryPurchaseModeElement = document.querySelector(
                'label[for="purchaseType"] + div .is-checked .el-radio__label'
            );
            if (primaryPurchaseModeElement && primaryPurchaseModeElement.textContent) {
                purchaseMode = primaryPurchaseModeElement.textContent.trim();
            } else {
                purchaseMode = extractRadioValue(
                    "#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(6) > div > div > div > div",
                    ["框架", "专项"]
                );
            }
            results["采购模式"] = purchaseMode;

            // 采购方式（从 prop="purchaseWay" 的 el-select 中读取）
            let procurementMethod = "";

            // 1. 优先从 prop="purchaseWay" 下拉框当前选中值读取
            const purchaseWayFormItem = document.querySelector('[prop="purchaseWay"]');
            if (purchaseWayFormItem) {
                const purchaseInput = purchaseWayFormItem.querySelector(
                    ".el-form-item__content .el-select .el-input__inner"
                );
                if (purchaseInput && purchaseInput.value) {
                    procurementMethod = purchaseInput.value.trim();
                }
            }

            // 2. 如果没取到，再做一次兜底
            if (!procurementMethod) {
                const fallbackInput = document.querySelector(
                    '.el-form-item[prop="purchaseWay"] .el-input__inner'
                );
                if (fallbackInput && fallbackInput.value) {
                    procurementMethod = fallbackInput.value.trim();
                }
            }

            // 3. 内部供给方式增强（如：内部供给采购（邀请竞价））
            procurementMethod = enhanceInternalSupplyMethod(procurementMethod);

            // 4. 其它映射
            if (procurementMethod === "沿用框招结果") procurementMethod = "框架内采购";
            if (procurementMethod === "电商化采购") procurementMethod = "电子商城采购";

            results["采购方式"] = procurementMethod;

            // 预估金额
            const estimatedAmountElement = document.querySelector(
                'div[prop="estimatedAmount"] > div.el-form-item__content > div.el-input > input'
            );
            let estimatedAmount = estimatedAmountElement?.value || "";
            if (!estimatedAmount) {
                const backupElement = document.querySelector(
                    "#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(24) > div > div > div > input"
                );
                estimatedAmount = backupElement?.value || "";
            }
            results["预估金额（元）"] = estimatedAmount;

            // 控制台输出
            console.log("=============== 采购信息提取结果 ===============");
            console.log(`当前页面类型: ${pageType}`);
            fieldOrder.forEach((field) => {
                console.log(`${field}：${results[field] || "未获取到值"}`);
            });
            console.log("=============================================");

            // 复制到剪贴板（按顺序拼接）
            const resultString = fieldOrder.map((f) => results[f] || "").join("\t");
            GM_setClipboard(resultString, "text");

            showCopySuccessToast("采购信息已复制到剪贴板");
            extractedData = results;

            console.log("============ 复制到剪贴板的文本顺序 =============");
            console.log("字段顺序：", fieldOrder.join("\t"));
            console.log("文本内容：", resultString);
            console.log("=============================================");
        } catch (error) {
            console.error("提取信息时出错:", error);
        }
    });

    // 创建目录按钮
    const createDirButton = createButton("创建目录", "create-directory-btn", "#67c23a", async function () {
        try {
            const currentData = {};

            // 申请人、审批时间
            await extractApplicantAndApprovalTime(currentData);

            // 项目名称
            let projectName = "";
            const primaryProjectElement = document.querySelector('[for="projectName"]+ div input');
            if (primaryProjectElement && primaryProjectElement.value) {
                projectName = primaryProjectElement.value;
            } else {
                projectName = extractValue(
                    "#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(3) > div > div > div > input"
                );
            }
            currentData["项目名称"] = projectName;

            // 内部编号
            let internalId = "";
            const primaryInternalIdElement = document.querySelector('[for="orgInnerCode"]+ div input');
            if (primaryInternalIdElement && primaryInternalIdElement.value) {
                internalId = primaryInternalIdElement.value;
            } else {
                const internalIdElement = document.querySelector('input[placeholder="公司内部编号"]');
                internalId = internalIdElement ? internalIdElement.value : "";
            }
            let internalId_wrapper = document.querySelector('[prop="serialNo"]');
            let internalId_input = internalId_wrapper
                ? internalId_wrapper.querySelector("input.el-input__inner")
                : null;
            let internalId_val = internalId_input ? internalId_input.value : null;
            internalId = internalId_val;
            currentData["内部编号"] =
                internalId && internalId.trim() !== "" ? internalId.trim() : "无";

            // 采购方式（从 prop="purchaseWay" 的 el-select 中读取）
            let procurementMethod = "";

            const purchaseWayFormItem2 = document.querySelector('[prop="purchaseWay"]');
            if (purchaseWayFormItem2) {
                const purchaseInput2 = purchaseWayFormItem2.querySelector(
                    ".el-form-item__content .el-select .el-input__inner"
                );
                if (purchaseInput2 && purchaseInput2.value) {
                    procurementMethod = purchaseInput2.value.trim();
                }
            }

            if (!procurementMethod) {
                const fallbackInput2 = document.querySelector(
                    '.el-form-item[prop="purchaseWay"] .el-input__inner'
                );
                if (fallbackInput2 && fallbackInput2.value) {
                    procurementMethod = fallbackInput2.value.trim();
                }
            }

            procurementMethod = enhanceInternalSupplyMethod(procurementMethod);

            if (procurementMethod === "沿用框招结果") procurementMethod = "框架内采购";
            if (procurementMethod === "电商化采购") procurementMethod = "电子商城采购";
            currentData["采购方式"] = procurementMethod;

            const applicant = currentData["申请人"];
            const approvalDate = currentData["采购审批完成时间"];
            projectName = currentData["项目名称"];
            internalId = currentData["内部编号"];

            let procurementMethodForDir = procurementMethod;

            let directoryText;
            if (procurementMethodForDir === "零星采购") {
                directoryText = `${procurementMethodForDir} - - ${internalId} - - ${approvalDate} - - ${projectName} - - ${applicant}`;
            } else {
                directoryText = `${procurementMethodForDir} - - ${approvalDate} - - ${internalId} - - ${projectName} - - ${applicant}`;
            }

            GM_setClipboard(directoryText, "text");
            showCopySuccessToast("目录文本已复制到剪贴板");

            console.log("=============== 创建的目录文本 ===============");
            console.log(directoryText);
            console.log("=============================================");
        } catch (error) {
            console.error("创建目录时出错:", error);
        }
    });

    buttonContainer.appendChild(extractButton);
    buttonContainer.appendChild(createDirButton);
    document.body.appendChild(buttonContainer);

    // 创建按钮工具函数
    function createButton(text, id, color, onClick) {
        const button = document.createElement("button");
        button.textContent = text;
        button.id = id;
        button.style.padding = "10px 20px";
        button.style.backgroundColor = color;
        button.style.color = "white";
        button.style.border = "none";
        button.style.borderRadius = "4px";
        button.style.cursor = "pointer";
        button.style.boxShadow = "0 2px 10px rgba(0, 0, 0, 0.2)";
        button.style.fontSize = "14px";
        button.style.fontWeight = "bold";
        button.style.transition = "all 0.2s ease-in-out";
        button.addEventListener("click", onClick);
        return button;
    }

    // 内部供给方式增强函数：把 1/2 映射为中文并拼接
    function enhanceInternalSupplyMethod(procurementMethod) {
        if (procurementMethod !== "内部供给采购") return procurementMethod;

        const internalTypeFormItem = document.querySelector('[prop="internalType"]');
        if (!internalTypeFormItem) return procurementMethod;

        const checkedRadio = internalTypeFormItem.querySelector("label.el-radio.is-checked");
        if (!checkedRadio) return procurementMethod;

        const radioInput = checkedRadio.querySelector("input.el-radio__original");
        const value = radioInput?.value || radioInput?.getAttribute("value");
        if (!value) return procurementMethod;

        let text = "";
        if (value === "1") text = "邀请竞价";
        else if (value === "2") text = "自主开展谈判";
        else text = value; // 兜底：如果将来有新值，至少不会丢

        return `内部供给采购（${text}）`;
    }

    // 提取申请人和审批完成时间
    async function extractApplicantAndApprovalTime(results) {
        let tab2 = null;
        const tabItems = document.querySelectorAll(".el-tabs__item");
        for (const item of tabItems) {
            if ((item.textContent || "").trim() === "流转列表") {
                tab2 = item;
                break;
            }
        }
        if (!tab2) tab2 = document.querySelector("#tab-2");
        if (!tab2) return;

        const clickEvent = new MouseEvent("click", {
            bubbles: true,
            cancelable: true
        });
        tab2.dispatchEvent(clickEvent);

        const allTabs = document.querySelectorAll(".el-tabs__item");
        allTabs.forEach((tab) => {
            tab.classList.remove("is-active");
            tab.removeAttribute("aria-selected");
            tab.setAttribute("tabindex", "-1");
        });
        tab2.classList.add("is-active");
        tab2.setAttribute("aria-selected", "true");
        tab2.setAttribute("tabindex", "0");

        const activeBar = document.querySelector(".el-tabs__active-bar");
        if (activeBar) {
            const tabIndex = Array.from(allTabs).indexOf(tab2);
            const tabWidth = tab2.offsetWidth;
            const tabOffset = tab2.offsetLeft;
            activeBar.style.width = tabWidth + "px";
            activeBar.style.transform = `translateX(${tabOffset}px)`;
        }

        await new Promise((resolve) => setTimeout(resolve, 500));

        try {
            // 申请人：流转列表第一行，第2列
            const applicantRow = document.querySelector(
                "#pane-2 > div > div.tableContainer.recordListTable > div > div.el-table__body-wrapper.is-scrolling-none > table > tbody > tr:nth-child(1)"
            );
            if (applicantRow) {
                const secondTd = applicantRow.querySelector("td:nth-child(2)");
                if (secondTd) {
                    const applicantDiv = secondTd.querySelector("div");
                    if (applicantDiv) {
                        results["申请人"] = applicantDiv.textContent.trim().split("/")[0];
                    }
                }
            }

            // 审批完成时间：最后一行，第3列里的日期部分
            const rows = document.querySelectorAll(
                "#pane-2 > div > div.tableContainer.recordListTable > div > div.el-table__body-wrapper.is-scrolling-none > table > tbody > tr"
            );
            if (rows.length > 0) {
                const lastRow = rows[rows.length - 1];
                const timeElement = lastRow.querySelector("td:nth-child(3) > div");
                let approvalDate = timeElement ? timeElement.textContent.trim() : "";
                const match = approvalDate.match(/\d{4}-\d{2}-\d{2}/);
                results["采购审批完成时间"] = match ? match[0] : "";
            }
        } catch (e) {
            console.error("获取申请人或审批时间失败:", e);
        } finally {
            // 切回表单信息 tab
            let formInfoTab = null;
            const tabElements = document.getElementsByClassName("el-tabs__item is-top");
            for (let i = 0; i < tabElements.length; i++) {
                const tab = tabElements[i];
                const tabText = (tab.textContent || "").trim();
                if (tabText.includes("表单信息")) {
                    formInfoTab = tab;
                    break;
                }
            }

            if (formInfoTab) {
                const clickEventReturn = new MouseEvent("click", {
                    bubbles: true,
                    cancelable: true
                });
                formInfoTab.dispatchEvent(clickEventReturn);

                const allTabsReturn = document.querySelectorAll(".el-tabs__item");
                allTabsReturn.forEach((tab) => {
                    tab.classList.remove("is-active");
                    tab.removeAttribute("aria-selected");
                    tab.setAttribute("tabindex", "-1");
                });
                formInfoTab.classList.add("is-active");
                formInfoTab.setAttribute("aria-selected", "true");
                formInfoTab.setAttribute("tabindex", "0");

                const activeBarReturn = document.querySelector(".el-tabs__active-bar");
                if (activeBarReturn) {
                    const tabIndexReturn = Array.from(allTabsReturn).indexOf(formInfoTab);
                    const tabWidthReturn = formInfoTab.offsetWidth;
                    const tabOffsetReturn = formInfoTab.offsetLeft;
                    activeBarReturn.style.width = tabWidthReturn + "px";
                    activeBarReturn.style.transform = `translateX(${tabOffsetReturn}px)`;
                }

                await new Promise((resolve) => setTimeout(resolve, 500));
            } else {
                console.error("未找到表单信息标签页，无法返回");
            }
        }
    }

    // 通用工具函数
    async function extractValueAfterDelay(selector, delay) {
        await new Promise((resolve) => setTimeout(resolve, delay));
        const element = document.querySelector(selector);
        return element ? element.value : "";
    }

    function extractValue(selector) {
        const element = document.querySelector(selector);
        return element
            ? (element.value || "").replace(/[\s\u200B-\u200D\uFEFF]/g, "")
            : "";
    }

    function extractRadioValue(containerSelector, options) {
        const container = document.querySelector(containerSelector);
        if (!container) return "";
        const labels = container.querySelectorAll("label");
        for (let i = 0; i < labels.length; i++) {
            if (labels[i].classList.contains("is-checked")) {
                return options[i] || "";
            }
        }
        return "";
    }

    function showCopySuccessToast(message) {
        const toast = document.createElement("div");
        toast.className = "copy-success-toast";
        toast.textContent = message;

        document.body.appendChild(toast);

        setTimeout(() => {
            toast.classList.add("fade-out");
        }, 2000);

        setTimeout(() => {
            if (toast.parentNode) {
                toast.parentNode.removeChild(toast);
            }
        }, 2500);
    }
})();