// ==UserScript==
// @name         格式化复制的模型名称
// @namespace    http://tampermonkey.net/
// @match        https://aihubmix.com/models
// ==/UserScript==

(function () {
	"use strict";
	//等待页面加载完毕
	window.addEventListener("load", function () {
		// 给所有包含anticon-copy的span元素绑定点击事件
		document.querySelectorAll('span[class*="anticon-copy"]').forEach(function (span) {
			span.addEventListener("click", function (event) {
				// 阻止默认行为（2种）
				event.preventDefault();
				event.stopPropagation();
				// 获取上级元素
				var parent = span.parentNode;
				// 获取文本内容
				var text = parent.textContent.trim();
				// 前面加上+，后面加上@OPENAI
				text = "+" + text + "@OpenAI,";
				// 复制到剪贴板
				navigator.clipboard.writeText(text)
					.then(() => {
					console.log('Text successfully copied to clipboard!');
					console.log(text);
				})
					.catch(err => {
					console.error('Error copying text: ', err);
				});
			});
		});
	});
})();
