// ==UserScript==
// @name         获取公司采购表单内容
// @namespace    http://tampermonkey.net/
// @version      2025-02-07
// @description  try to take over the world!
// @author       You
// @match        https://ims.ynydtk.com:8443/buyv2/
// @icon         https://www.google.com/s2/favicons?sz=64&domain=ynydtk.com
// @grant        none
// ==/UserScript==

(function() {
    'use strict';

    // 创建一个按钮
    const button = document.createElement('button');
    button.textContent = '提取表单内容';
    button.style.position = 'fixed';
    button.style.top = '10px';
    button.style.right = '10px';
    button.style.zIndex = '9999';
    document.body.appendChild(button);

    button.addEventListener('click', function() {
        // 获取所有tr元素
        const rows = document.querySelectorAll('[data-v-0ebde73c=""] tr');
        let extractedText = '';

        // 获取标题
        const title = document.querySelector('[data-v-0ebde73c=""] h5');
        if (title) {
            extractedText += title.textContent.trim() + '\n\n';
        }

        // 遍历每个tr
        rows.forEach(row => {
            const cells = row.querySelectorAll('td');
            cells.forEach(cell => {
                let cellText = cell.textContent.trim();
                if (cellText) {
                    extractedText += cellText + '\n';
                }
            });
            extractedText += '\n';
        });

        // 创建文本区域显示结果
        const textarea = document.createElement('textarea');
        textarea.value = extractedText;
        textarea.style.position = 'fixed';
        textarea.style.top = '50px';
        textarea.style.right = '10px';
        textarea.style.width = '400px';
        textarea.style.height = '600px';
        textarea.style.zIndex = '9999';
        document.body.appendChild(textarea);

        // 复制到剪贴板
        textarea.select();
        document.execCommand('copy');
        alert('内容已复制到剪贴板！');
    });
})();