// ==UserScript==
// @name         自动选择及样式
// @namespace    http://tampermonkey.net/
// @version      2024-10-22
// @description  自动选择及样式
// @author       Daniel Du
// @match        https://*.dedegpt.vip/list
// @icon         https://www.google.com/s2/favicons?sz=64&domain=dedegpt.vip
// @grant        none
// ==/UserScript==
(function () {
	// 设置小手样式
	document.body.addEventListener("mouseover", function (event) {
		if (event.target.classList.contains("boxclass")) {
			event.target.style.cursor = "pointer";
		}
	});

	// 创建一个按钮并添加到页面上
	const autoSelectButton = document.createElement("button");
	autoSelectButton.id = "checkAndClickButton";
	autoSelectButton.innerText = "自动选择";
	Object.assign(autoSelectButton.style, {
		fontSize: "14px",
		width: "80px",
		height: "30px",
		cursor: "pointer",
		position: "absolute",
		bottom: "10px",
		right: "50%",
		left: "50%",
		marginLeft: "-40px",
		borderRadius: "10px",
		border: "2px solid gray",
		fontFamily: "'思源黑体 CN Medium', sans-serif",
		transition: "background-color 0.3s ease",
	});
	autoSelectButton.addEventListener("mouseover", function () {
		autoSelectButton.style.backgroundColor = "lightgray";
	});
	autoSelectButton.addEventListener("mouseout", function () {
		autoSelectButton.style.backgroundColor = "";
	});
	document
		.querySelector("#app > div > div.n-card.n-card--bordered.notice > div")
		.appendChild(autoSelectButton);
	// 获取位置
	// newButton 添加点击事件监听器
	autoSelectButton.addEventListener("click", function () {
		let flg4 = 0;
		let flg3 = 0;
		let flg2 = 0;
		let flg1 = 0;
		// js文本标记，用于跳出循环
		// 遍历所有的 boxclass 元素
		document.querySelectorAll(".boxclass").forEach((element, index) => {
			// 如果元素的文本内容包含“保留”就跳过
			if (element.textContent.includes("保留")) {
				console.log("跳过包含“保留”的元素");
			} else {
				const staus_div = element.querySelector(".arco-progress-steps");
				// 检测包含style="background-color: rgb(36, 212, 174);"的div有几个
				let count = staus_div.querySelectorAll(
					'div[style="background-color: rgb(36, 212, 174);"]',
				).length;
				// 遍历所有，如果找到四个的就点击，没有就找三个的，没有就找两个的，没有就找一个的
				if (count === 4) {
					if (flg4 === 0) {
						flg4 = index;
						return;
					}
				} else if (count === 3) {
					if (flg3 === 0) {
						flg3 = index;
						return;
					}
				} else if (count === 2) {
					if (flg2 === 0) {
						flg2 = index;
						return;
					}
				} else if (count === 1) {
					if (flg1 === 0) {
						flg1 = index;
						return;
					}
				}
			}
			index++;
		});
		let target_element = false;
		if (flg4 > 0) {
			target_element = document.querySelectorAll(".boxclass")[flg4];
		} else if (flg3 > 0) {
			target_element = document.querySelectorAll(".boxclass")[flg3];
		} else if (flg2 > 0) {
			target_element = document.querySelectorAll(".boxclass")[flg2];
		} else if (flg1 > 0) {
			target_element = document.querySelectorAll(".boxclass")[flg1];
		} else {
			alert("没有合适的车");
		}
		if (target_element) {
			// 闪烁目标（改变背景色）
			setInterval(() => {
				target_element.style.backgroundColor = "pink";
				setTimeout(() => {
					target_element.style.backgroundColor = "";
				}, 100);
			}, 300);
			setTimeout(() => {
				target_element.click();
			}, 2000);
		}
	});
})();
