// ==UserScript==
// @name         企信-样式切换器
// @namespace    http://tampermonkey.net/
// @version      0.1
// @description  在ims.ynydtk.com页面上切换自定义样式
// @author       You
// @match        https://qx.ynydtk.cn:8443/buyv2/
// @grant        GM_addStyle
// @grant        GM_getValue
// @grant        GM_setValue
// ==/UserScript==

(function() {
    'use strict';

    // 检查样式是否已应用的存储键
    const STYLE_APPLIED_KEY = 'custom_style_applied';
    const HIGHLIGHT_APPLIED_KEY = 'highlight_applied'; // 新增一个存储键

    // 自定义样式
    const customStyle = `
        .el-radio.is-checked .el-radio__label {
            color: red !important;
            font-weight: bold !important;
            background-color: lightgreen !important;
            padding: 2px 6px 2px 2px !important;
            border-radius: 4px !important;
        }
    `;

    // 创建样式元素
    let styleElement = null;

    // 目标 input 元素的选择器
    const inputSelector = 'input[type="text"][disabled="disabled"][readonly="readonly"].el-input__inner[placeholder="请选择采购方式"]';

    // 创建一个 MutationObserver 实例
    const observer = new MutationObserver(mutations => {
        mutations.forEach(mutation => {
            if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
                for (const node of mutation.addedNodes) {
                    // 检查新添加的节点是否包含目标 input 元素
                    if (node.nodeType === Node.ELEMENT_NODE && node.querySelector(inputSelector)) {
                        processInput();
                        return; // 找到目标，立即返回，避免重复处理
                    }
                }
            }
        });
    });

    function processInput() {
        // 获取目标 input 元素
        const inputElement = document.querySelector(inputSelector);

        if (inputElement) {
            console.log("找到目标 input 元素:", inputElement);  // 添加日志
            // 获取 el-select 组件的父元素
            const elSelect = inputElement.closest('.el-select');
            if (!elSelect) {
                console.error('找不到 el-select 组件');
                return;
            }

             // 模拟点击 el-select，展开下拉菜单
            elSelect.click();

            // 短暂延迟后，查找选中的 span 元素
            setTimeout(() => {
                // 查找下拉菜单中带有 selected 类的 li 元素下的 span
                const selectedSpan = elSelect.querySelector('.el-select-dropdown__item.selected > span');
                let inputValue = '';

                if (selectedSpan) {
                    inputValue = selectedSpan.textContent.trim();
                }

                // 移除之前的 span 元素，避免重复添加
                const existingSpan = inputElement.nextElementSibling;
                if (existingSpan && existingSpan.classList.contains('highlighted-text')) {
                    existingSpan.remove();
                    inputElement.style.display = '';  // 恢复显示
                }

                // 创建一个 span 元素来包裹文字并添加背景色
                const span = document.createElement('span');
                span.classList.add('highlighted-text');
                span.textContent = inputValue;

                // 隐藏 input 元素，并将 span 元素插入到 input 元素后面，模拟文字高亮效果
                inputElement.style.display = 'none';
                inputElement.parentNode.insertBefore(span, inputElement.nextSibling);

                // 设置 span 元素的样式
                span.style.backgroundColor = 'lightgreen'; // 设置背景颜色
                span.style.padding = '0 2px';        // 可选：添加一些内边距
                span.style.borderRadius = '3px';     // 可选：添加圆角
                span.style.font = window.getComputedStyle(inputElement).font; // 继承字体样式
                span.style.color = 'red';
				span.style.fontSize = '16px';
				span.style.fontWeight = 'bold';
               // span.style.position = 'absolute'; // 使 span 元素脱离文档流

                 span.style.position = 'relative'; //  设置定位方式为相对定位， 方便修改
                 span.style.left = '31%'; //  设置左边距
                 span.style.top = '0px';  // 设置顶边距
                 span.style.whiteSpace = 'nowrap'; // 防止文本换行


                // 再次点击 el-select，关闭下拉菜单
                elSelect.click();
            }, 2000); // 延迟 200 毫秒，确保下拉菜单已经渲染

        }
    }

    // 添加切换按钮
    function addToggleButton() {
        const button = document.createElement('button');

        // 按钮样式 - 居中位置
        button.style.position = 'fixed';
        button.style.top = '78px';
        button.style.left = '56%';
        button.style.transform = 'translate(-50%, -50%)';
        button.style.zIndex = '9999';
        button.style.padding = '8px 16px';
        button.style.backgroundColor = '#4CAF50';
        button.style.color = 'white';
        button.style.border = 'none';
        button.style.borderRadius = '4px';
        button.style.cursor = 'pointer';
        button.style.fontSize = '16px';
        button.style.boxShadow = '0 2px 5px rgba(0,0,0,0.2)';

        // 初始化状态
        let isStyleApplied = GM_getValue(STYLE_APPLIED_KEY, false);
        let isHighlightApplied = GM_getValue(HIGHLIGHT_APPLIED_KEY, false); // 获取高亮状态

        updateButtonState(button, isStyleApplied, isHighlightApplied); // 初始设置按钮文本

        if (isStyleApplied) {
            applyStyle();
        }
        if (isHighlightApplied) {
            observer.observe(document.body, {
                childList: true,
                subtree: true,
            });
        }

        button.addEventListener('click', function() {
            // 切换状态
            isStyleApplied = !isStyleApplied;
            isHighlightApplied = !isHighlightApplied;

            // 保存状态
            GM_setValue(STYLE_APPLIED_KEY, isStyleApplied);
            GM_setValue(HIGHLIGHT_APPLIED_KEY, isHighlightApplied); // 保存高亮状态

            updateButtonState(button, isStyleApplied, isHighlightApplied); // 更新按钮文本

            // 应用/移除样式
            if (isStyleApplied) {
                applyStyle();
            } else {
                removeStyle();
            }

            // 启动/停止监听高亮
            if (isHighlightApplied) {
                observer.observe(document.body, {
                    childList: true,
                    subtree: true,
                });
                processInput();
            } else {
                observer.disconnect();
                const inputElement = document.querySelector(inputSelector);
                if (inputElement) {
                    const existingSpan = inputElement.nextElementSibling;
                    if (existingSpan && existingSpan.classList.contains('highlighted-text')) {
                        existingSpan.remove();
                        inputElement.style.display = '';  // 恢复显示
                    }
                }
            }
        });
        document.body.appendChild(button);
    }

    // 更新按钮状态
    function updateButtonState(button, isStyleApplied, isHighlightApplied) {
        let text = '应用';
        let backgroundColor = '#4CAF50';

        if (isStyleApplied || isHighlightApplied) {
            text = '取消';
            backgroundColor = '#f44336';
        }

        button.textContent = text + '样式';
        button.style.backgroundColor = backgroundColor;
    }

    // 应用样式
    function applyStyle() {
        if (!styleElement) {
            styleElement = document.createElement('style');
            styleElement.id = 'custom-radio-style';
            styleElement.textContent = customStyle;
            document.head.appendChild(styleElement);
        }
    }

    // 移除样式
    function removeStyle() {
        if (styleElement) {
            styleElement.remove();
            styleElement = null;
        }
    }

    // 初始化：页面加载完成后立即执行一次
    window.addEventListener('load', () => {});

    // 等待页面加载完成后添加按钮
    if (document.readyState === 'complete' || document.readyState === 'interactive') {
        setTimeout(addToggleButton, 1200);
    } else {
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(addToggleButton, 1200);
        });
    }
})();
