// ==UserScript==
// @name         采购信息提取工具（适配flowDone和flowTodo）
// @namespace    http://tampermonkey.net/
// @version      1.3
// @description  提取采购信息并在控制台清晰显示，适配flowDone和flowTodo页面
// @author       You
// @match        https://qx.ynydtk.cn:8443/buyv2/*
// @grant        GM_setClipboard
// ==/UserScript==

(function () {
	"use strict";

	// 创建按钮容器
	const buttonContainer = document.createElement("div");
	buttonContainer.style.position = "fixed";
	buttonContainer.style.top = "120px";
	buttonContainer.style.left = "53%";
	buttonContainer.style.transform = "translateX(-50%)";
	buttonContainer.style.zIndex = "9999";
	buttonContainer.style.display = "flex";
	buttonContainer.style.gap = "20px";

	// 添加打印时隐藏按钮的样式
	const style = document.createElement("style");
	style.textContent = `
        @media print {
            #extract-purchase-info-btn,
            #create-directory-btn {
                display: none !important;
            }
        }
    `;
	document.head.appendChild(style);

	// 1. 创建"提取采购信息"按钮
	const extractButton = createButton("提取采购信息", "extract-purchase-info-btn", "#409eff", async function () {
		try {
			// 清空控制台
			console.clear();

			// 获取当前URL路径
			const isFlowTodo = window.location.href.includes("/flowTodo");

			// 严格按照顺序定义字段
			const fieldOrder = ["是否", "是否本周", "成本费用列支", "申请部门", "申请人", "项目名称", "内部编号",
				"采购审批完成时间", "项目类型", "采购模式", "采购方式", "预估金额（元）"];

			// 初始化结果对象
			const results = {};

			// 1. 是否（固定值）
			results["是否"] = "否";

			// 2. 是否本周（公式）
			results["是否本周"] = "=IF(AND([@采购审批完成时间]>=TODAY()-WEEKDAY(TODAY(),2)+1,[@采购审批完成时间]<=TODAY()-WEEKDAY(TODAY(),2)+7),\"是\",\"否\")";

			// 3. 成本费用列支（根据页面类型选择不同位置）
			const costSelectors = isFlowTodo ? ["#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(13) > div > div > div > input",
				"#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(14) > div > div > div > input"] : ["#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(14) > div > div > div > input",
				"#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(15) > div > div > div > input"];
			results["成本费用列支"] = getFirstValidValue(costSelectors);

			// 4. 申请部门（公式）
			results["申请部门"] = "=IF([@申请人]=\"\",\"未找到对应部门\",XLOOKUP([@申请人],人员名单及部门列表!A:A,人员名单及部门列表!B:B,\"未找到对应部门\",0))";

			// 5. 申请人和8.采购审批完成时间（需要切换标签页）
			await extractApplicantAndApprovalTime(results);

			// 6. 项目名称
			results["项目名称"] = extractValue("#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(3) > div > div > div > input");

			// 7. 内部编号（根据页面类型选择不同位置）
			const internalIdSelectors = isFlowTodo ? ["#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(11) > div > div > div > input",
				"#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(12) > div > div > div > input"] : ["#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(12) > div > div > div > input",
				"#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(13) > div > div > div > input"];
			results["内部编号"] = getFirstValidValue(internalIdSelectors);

			// 9. 项目类型（通过label类名判断）
			results["项目类型"] = extractRadioValue("#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(7) > div > div > div > div", ["货物类",
				"服务类", "工程类"]);

			// 10. 采购模式（通过label类名判断）
			results["采购模式"] = extractRadioValue("#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(6) > div > div > div > div", ["框架",
				"专项"]);

			// 11. 采购方式
			results["采购方式"] = extractValue("#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(4) > div > div > div > div.el-input.el-input--small.is-disabled.el-input--suffix > input");

			// 12. 预估金额（元）
			results["预估金额（元）"] = extractValue("#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(21) > div > div > div > input");

			// 在控制台打印结果
			console.log("====== 采购信息提取结果 ======");
			console.log(`当前页面类型: ${isFlowTodo ? "flowTodo" : "flowDone"}`);
			fieldOrder.forEach(field => {
				console.log(`${field}：${results[field] || "未获取到值"}`);
			});
			console.log("=============================");

			// 同时复制到剪贴板（制表符分隔）
			const resultString = fieldOrder.map(field => results[field] || "").join("\t");
			GM_setClipboard(resultString, "text");
		} catch (error) {
			console.error("提取信息时出错:", error);
		}
	});

	// 2. 创建"创建目录"按钮
	const createDirButton = createButton("创建目录", "create-directory-btn", "#67c23a", async function () {
		try {
			// 获取必要字段
			const procurementMethod = extractValue("#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(4) > div > div > div > div.el-input.el-input--small.is-disabled.el-input--suffix > input");

			// 获取内部编号（根据页面类型选择不同位置）
			const isFlowTodo = window.location.href.includes("/flowTodo");
			const internalIdSelectors = isFlowTodo ? ["#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(11) > div > div > div > input",
				"#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(12) > div > div > div > input"] : ["#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(12) > div > div > div > input",
				"#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(13) > div > div > div > input"];
			const internalId = getFirstValidValue(internalIdSelectors);

			// 获取项目名称
			const projectName = extractValue("#pane-0 > div:nth-child(2) > div.word-form.el-row > form > div:nth-child(3) > div > div > div > input");

			// 获取申请人
			let applicant = "";
			const tab2 = document.querySelector("#tab-2");
			if (tab2) {
				const activeTab = document.querySelector(".el-tabs__item.is-active");
				tab2.click();
				await new Promise(resolve => setTimeout(resolve, 200));

				try {
					const applicantRow = document.querySelector("#pane-2 > div > div.tableContainer.recordListTable > div > div.el-table__body-wrapper.is-scrolling-none > table > tbody > tr:nth-child(1)");
					if (applicantRow) {
						const secondTd = applicantRow.querySelector("td:nth-child(2)");
						if (secondTd) {
							const applicantDiv = secondTd.querySelector("div");
							if (applicantDiv) {
								applicant = applicantDiv.textContent.trim().split("/")[0];
							}
						}
					}
				} finally {
					if (activeTab) {
						activeTab.click();
					}
				}
			}

			// 获取申请日期（采购审批完成时间）
			let approvalDate = "";
			const rows = document.querySelectorAll("#pane-2 > div > div.tableContainer.recordListTable > div > div.el-table__body-wrapper.is-scrolling-none > table > tbody > tr");
			if (rows.length > 0) {
				const lastRow = rows[rows.length - 1];
				const timeElement = lastRow.querySelector("td:nth-child(3) > div");
				approvalDate = timeElement ? timeElement.textContent.trim() : "";
				approvalDate = approvalDate.match(/\d{4}-\d{2}-\d{2}/);
			}

			// 根据采购方式决定顺序
			let directoryText;
			if (procurementMethod === "零星采购") {
				directoryText = `${procurementMethod} -- ${internalId} -- ${approvalDate} -- ${projectName} -- ${applicant}`;
			} else {
				directoryText = `${procurementMethod} -- ${approvalDate} -- ${internalId} -- ${projectName} -- ${applicant}`;
			}

			// 复制到剪贴板
			GM_setClipboard(directoryText, "text");

			// 在控制台显示
			console.log("====== 创建的目录文本 ======");
			console.log(directoryText);
			console.log("===========================");
		} catch (error) {
			console.error("创建目录时出错:", error);
		}
	});

	// 将按钮添加到容器
	buttonContainer.appendChild(extractButton);
	buttonContainer.appendChild(createDirButton);

	// 将容器添加到页面
	document.body.appendChild(buttonContainer);

	// 辅助函数：创建按钮
	function createButton(text, id, color, onClick) {
		const button = document.createElement("button");
		button.textContent = text;
		button.id = id;
		button.style.padding = "10px 20px";
		button.style.backgroundColor = color;
		button.style.color = "white";
		button.style.border = "none";
		button.style.borderRadius = "4px";
		button.style.cursor = "pointer";
		button.style.boxShadow = "0 2px 10px rgba(0, 0, 0, 0.2)";
		button.style.fontSize = "14px";
		button.style.fontWeight = "bold";
		button.addEventListener("click", onClick);
		return button;
	}

	// 辅助函数：提取申请人和审批完成时间
	async function extractApplicantAndApprovalTime(results) {
		const tab2 = document.querySelector("#tab-2");
		if (!tab2) {
			return;
		}

		// 保存当前活动标签页
		const activeTab = document.querySelector(".el-tabs__item.is-active");

		// 切换到第二个标签页
		tab2.click();

		// 等待内容加载（200ms）
		await new Promise(resolve => setTimeout(resolve, 200));

		try {
			// 获取申请人（第二个td下的div）
			const applicantRow = document.querySelector("#pane-2 > div > div.tableContainer.recordListTable > div > div.el-table__body-wrapper.is-scrolling-none > table > tbody > tr:nth-child(1)");
			if (applicantRow) {
				const secondTd = applicantRow.querySelector("td:nth-child(2)");
				if (secondTd) {
					const applicantDiv = secondTd.querySelector("div");
					if (applicantDiv) {
						// 去除"/"及后面的内容
						results["申请人"] = applicantDiv.textContent.trim().split("/")[0];
					}
				}
			}

			// 获取审批完成时间（从最后一行第三个td）
			const rows = document.querySelectorAll("#pane-2 > div > div.tableContainer.recordListTable > div > div.el-table__body-wrapper.is-scrolling-none > table > tbody > tr");
			if (rows.length > 0) {
				const lastRow = rows[rows.length - 1];
				const timeElement = lastRow.querySelector("td:nth-child(3) > div");
				let approvalDate2 = timeElement ? timeElement.textContent.trim() : "";
				approvalDate2 = approvalDate2.match(/\d{4}-\d{2}-\d{2}/);
				results["采购审批完成时间"] = approvalDate2;
			}
		} catch (e) {
			console.error("获取申请人或审批时间失败:", e);
		} finally {
			// 恢复原来的活动标签页
			if (activeTab) {
				activeTab.click();
			}
		}
	}

	// 辅助函数：提取输入框的值
	function extractValue(selector) {
		const element = document.querySelector(selector);
		return element ? element.value : "";
	}

	// 辅助函数：从多个选择器中获取第一个有值的
	function getFirstValidValue(selectors) {
		for (const selector of selectors) {
			const value = extractValue(selector);
			if (value) {
				return value;
			}
		}
		return "";
	}

	// 辅助函数：提取单选按钮的值（通过检查label的is-checked类）
	function extractRadioValue(containerSelector, options) {
		const container = document.querySelector(containerSelector);
		if (!container) {
			return "";
		}

		const labels = container.querySelectorAll("label");
		for (let i = 0; i < labels.length; i++) {
			if (labels[i].classList.contains("is-checked")) {
				return options[i] || '';
			}
		}
		return '';
	}
})();
