// ==UserScript==
// @name         修改右侧流程审批高度
// @namespace    http://tampermonkey.net/
// @version      2025-02-07
// @description  try to take over the world!
// @author       You
// @author       You
// @match        https://ims.ynydtk.com:8443/buyv2/
// @icon         https://www.google.com/s2/favicons?sz=64&domain=ynydtk.com
// @grant        none
// ==/UserScript==

(function () {
	"use strict";

	function addButton() {
		// 创建按钮
		const button = document.createElement("button");
		let isAtBottom = false; // 跟踪当前状态

		button.style.position = "fixed";
		button.style.top = "175px";
		button.style.right = "50px";
		button.style.zIndex = "9999";
		button.style.padding = "5px 10px";
		button.style.backgroundColor = "#4caf50";
		button.style.color = "white";
		button.style.border = "none";
		button.style.borderRadius = "4px";
		button.style.cursor = "pointer";

		// 设置初始文本
		button.innerHTML = "滚动到底部";

		// 鼠标悬停效果
		button.addEventListener("mouseover", () => {
			button.style.fontWeight = "bold";
		});
		button.addEventListener("mouseout", () => {
			button.style.fontWeight = "normal";
		});

		// 添加点击事件
		button.addEventListener("click", function () {
			const targetElement = document.querySelector("#pane-0 > div.block > div:nth-child(2) > ul");
			if (targetElement) {
				if (!isAtBottom) {
					// 滚动到底部
					targetElement.scrollIntoView({
						behavior: "smooth",
						block: "end"
					});
					button.innerHTML = "滚动到顶部";
					isAtBottom = true;
				} else {
					// 滚动到顶部
					targetElement.scrollIntoView({
						behavior: "smooth",
						block: "start"
					});
					button.innerHTML = "滚动到底部";
					isAtBottom = false;
				}
			}
		});

		// 添加 CSS 媒体查询，在打印时隐藏按钮
		const style = document.createElement("style");
		style.innerHTML = "@media print { button { display: none !important; } }";
		document.head.appendChild(style);

		// 将按钮添加到 body 中
		document.body.appendChild(button);

		// 监听打印事件，在打印前移除按钮，打印后重新添加
		window.addEventListener("beforeprint", () => {
			button.style.display = "none";
		});

		window.addEventListener("afterprint", () => {
			button.style.display = ""; // 恢复原始显示状态
		});
	}

	if (document.readyState === "complete" || document.readyState === "interactive") {
		setTimeout(addButton, 1000);
	} else {
		document.addEventListener("DOMContentLoaded", function () {
			setTimeout(addButton, 1000);
		});
	}
})();
