// ==UserScript==
// @name         本地获取数据
// @namespace    http://tampermonkey.net/
// @version      0.9
// @author       You
// @match        https://ims.ynydtk.com:8443/buyv2/*
// @grant        GM_addStyle
// @grant        GM_getValue
// @grant        GM_setValue
// @grant        GM_xmlhttpRequest
// @grant        GM_setClipboard
// ==/UserScript==

(function () {
    "use strict";

    let isFetching = false; // 将 isFetching 声明在函数作用域的顶部
    let cachedData = null;   // 用于缓存数据，避免重复请求

    // 添加按钮1
    function addButton1() {
        const button = createButton("获取数据", "60%", () => {
            if (!isFetching) {
                isFetching = true;
                updateButtonState(button, isFetching);
                getData(button);
            }
        });
        document.body.appendChild(button);
    }

    // 添加按钮2
    function addButton2() {
        const button = createButton("获取路径", "67%", () => {
            if (!isFetching) {
                isFetching = true;
                updateButtonState(button, isFetching);
                getPath(button);
            }
        });
        document.body.appendChild(button);
    }

    // 创建按钮的通用函数
    function createButton(text, left, onClick) {
        const button = document.createElement("button");
        button.textContent = text;
        button.style.position = "fixed";
        button.style.top = "78px";
        button.style.left = left;
        button.style.transform = "translate(-50%, -50%)";
        button.style.zIndex = "9999";
        button.style.padding = "8px 16px";
        button.style.backgroundColor = "#4caf50";
        button.style.color = "white";
        button.style.border = "none";
        button.style.borderRadius = "4px";
        button.style.cursor = "pointer";
        button.style.fontSize = "16px";
        button.style.boxShadow = "0 2px 5px rgba(0,0,0,0.2)";
        button.addEventListener("click", onClick);
        return button;
    }

    function getProjectCode() {
        try {
            return document.querySelector("#printdocument > div.st-info-body.qdlist > div > table > tr:nth-child(1) > td:nth-child(1)").textContent.split("：")[1];
        } catch (error) {
            console.error("无法获取项目编号:", error);
            return ""; // 或者返回一个默认值，如果适用
        }
    }

    // 获取数据的函数
    function getData(button) {
        // 清空控制台
        console.clear();

        const projectCode = getProjectCode();

        if (!projectCode) {
            isFetching = false;
            updateButtonState(button, isFetching);
            button.textContent = "获取项目编号失败";
            button.style.backgroundColor = "red";
            return;
        }

        const url = `https://ims.ynydtk.com:8443/biddingApi/api/bidding/PurchaseDemand/getAllByprojectCode?projectCode=${projectCode}&n=`;

        // 尝试从localStorage获取btoken
        let btoken = localStorage.getItem("bidding_token")?.replace("|String", "");

        if (!btoken) {
            console.error("未找到 bidding_token 在 localStorage 中");
            isFetching = false;
            updateButtonState(button, isFetching);
            button.textContent = "未找到 btoken";
            button.style.backgroundColor = "red";
            return;
        }
        console.log(projectCode);
        console.log("使用的 btoken:", btoken); // 在请求发送前打印 btoken

        GM_xmlhttpRequest({
            method: "GET",
            url: url,
            headers: {
                "accept": "application/json, text/plain, */*",
                "accept-encoding": "gzip, deflate, br, zstd",
                "accept-language": "zh-CN,zh;q=0.9,en;q=0.8",
                "btoken": btoken,
                "connection": "keep-alive",
                "dnt": "1",
                "host": "ims.ynydtk.com:8443",
                "jnpf-origin": "pc",
                "referer": "https://ims.ynydtk.com:8443/buyv2/",
                "sec-ch-ua": "\"Chromium\";v=\"136\", \"Google Chrome\";v=\"136\", \"Not.A/Brand\";v=\"99\"",
                "sec-ch-ua-mobile": "?0",
                "sec-ch-ua-platform": "\"macOS\"",
                "sec-fetch-dest": "empty",
                "sec-fetch-mode": "cors",
                "sec-fetch-site": "same-origin",
                "user-agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36",
            },
            onload: function (response) {
                isFetching = false;
                updateButtonState(button, isFetching);

                if (response.status === 200) {
                    try {
                        const data = JSON.parse(response.responseText);
                        console.log("数据获取成功:", data);
                        button.textContent = "获取成功";
                        button.style.backgroundColor = "green";

                        // 提取数据
                        cachedData = extractAndPrintData(data); // 缓存数据

                        // 调用函数点击流转列表并获取数据
                        setTimeout(() => {
                            clickFlowListAndExtractData(button, cachedData); //  传递 cachedData
                        }, 2000); // 延迟 2 秒

                    } catch (e) {
                        console.error("JSON 解析错误:", e);
                        button.textContent = "JSON 解析错误";
                        button.style.backgroundColor = "red";
                    }
                } else {
                    console.error("请求失败:", response.status, response.statusText);
                    button.textContent = "请求失败: " + response.status;
                    button.style.backgroundColor = "red";
                }
            },
            onerror: function (error) {
                console.error("请求出错:", error);
                isFetching = false;
                updateButtonState(button, isFetching);
                button.textContent = "请求出错";
                button.style.backgroundColor = "red";
            }
        });
    }

    // 获取路径的函数
    function getPath(button) {
        if (!cachedData) {
            console.warn("没有缓存数据，请先点击'获取数据'按钮");
            button.textContent = "请先获取数据";
            button.style.backgroundColor = "orange";
            isFetching = false;
            updateButtonState(button, isFetching);
            return;
        }

        // 从缓存中获取 applyPurchaseDate，如果没有则设置为默认值
        let applyPurchaseDate = cachedData.applyPurchaseDate || "";

        // 组装文本, 去除不可见字符和空格
        const purchaseWay = removeInvisibleCharactersAndSpaces(cachedData.purchaseWay);
        const projectType = removeInvisibleCharactersAndSpaces(cachedData.projectType);
        const orgInnerCode = removeInvisibleCharactersAndSpaces(cachedData.orgInnerCode);
        const projectName = removeInvisibleCharactersAndSpaces(cachedData.projectName);
        const applyUserStr = removeInvisibleCharactersAndSpaces(cachedData.applyUserStr);
        applyPurchaseDate = removeInvisibleCharactersAndSpaces(applyPurchaseDate);

        let textToCopy = "";

		if (cachedData.flow_status == '否') {
			applyPurchaseDate = '日期';
		}

		if (!cachedData.flow_status) {
			applyPurchaseDate = '日期';
		}
		console.log(cachedData.flow_status );

        if (purchaseWay.replace(' ', '') === "零星采购" || purchaseWay.replace(' ', '') === "电商化采购") {
            textToCopy = `${purchaseWay} - - ${orgInnerCode} - - ${applyPurchaseDate} - - ${projectName} - - ${applyUserStr}`;
        } else {
            textToCopy = `${purchaseWay} - - ${applyPurchaseDate} - - ${orgInnerCode} - - ${projectName} - - ${applyUserStr}`;
        }

        // 复制到剪贴板
        GM_setClipboard(textToCopy, "text");
        console.log("路径已复制到剪贴板:", textToCopy);
        button.textContent = "路径已复制";
        button.style.backgroundColor = "green";
        isFetching = false;
        updateButtonState(button, isFetching);
    }

    // 提取数据并返回的函数
    function extractAndPrintData(data) {
        try {
            if (!data || !data.data || !data.data.demand) {
                console.error("数据结构不完整，无法提取数据");
                return null;
            }
            const demandData = data.data.demand;
            const extractedData = {
                projectName: demandData.projectName || "",
                purchaseWay: demandData.purchaseWay || "",
                projectType: demandData.projectType || "",
                purchaseType: demandData.purchaseType || "",
                applyUserStr: demandData.applyUserStr || "",
                orgInnerCode: demandData.orgInnerCode || "",
                estimatedAmount: demandData.estimatedAmount || "",
                amountSource: demandData.amountSource || "",  // Add amountSource here
                applyPurchaseDate: "" // 初始化为空
            };
            return extractedData;
        } catch (error) {
            console.error("提取数据时出错:", error);
            return null;
        }
    }

    // 点击流转列表的函数并获取数据的函数
    function clickFlowListAndExtractData(button, extractedData) {
        try {
            const flowListTab = document.querySelector("#tab-2");

            if (!flowListTab) {
                console.warn("未找到流转列表的 tab (tab-2)，请检查选择器是否正确");
                button.textContent = "未找到流转列表";
                button.style.backgroundColor = "red";
                return;
            }

            flowListTab.click();
            console.log("成功点击流转列表 (tab-2)");

            // 延迟一段时间，等待数据加载
            setTimeout(() => {
                let applyPurchaseDate = ""; // 保存申请采购日期

                try {
                    const applyPurchaseDateElement = document.querySelector("#pane-2 > div > div.tableContainer.recordListTable > div > div.el-table__body-wrapper.is-scrolling-none > table > tbody > tr:last-child > td:nth-child(3)");
                    if (applyPurchaseDateElement) {
                        applyPurchaseDate = applyPurchaseDateElement.textContent.split(" ")[0] || "";
                        console.log("获取到的申请采购日期:", applyPurchaseDate);
                        extractedData.applyPurchaseDate = applyPurchaseDate;  // 更新 extractedData
                    } else {
                        console.warn("未找到申请采购日期元素，请检查选择器");
                        button.textContent = "未找到申请采购日期";
                        button.style.backgroundColor = "red";
                    }
                } catch (applyPurchaseDateError) {
                    console.error("获取申请采购日期出错:", applyPurchaseDateError);
                    button.textContent = "获取申请采购日期出错";
                    button.style.backgroundColor = "red";
                }

                try {
                    const lastRowFirstCell = document.querySelector("#pane-2 > div > div.tableContainer.recordListTable > div > div.el-table__body-wrapper.is-scrolling-none > table > tbody > tr:last-child > td:first-child");
                    if (lastRowFirstCell) {
                        const thisStep = lastRowFirstCell.textContent || "";
                        console.log("获取到的 thisStep:", thisStep);

                        let flow_status = "";

                        console.log(extractedData.estimatedAmount);
                        console.log(thisStep.indexOf("分管"));

                        if (extractedData.estimatedAmount >= 100000) {
                            if (thisStep != "采购领导小组组长") {
                                flow_status = "否";
                            } else {
                                flow_status = "是";
                            }
                        } else {
                            if (thisStep.indexOf("分管") == -1) {
                                flow_status = "否";
                            } else {
                                flow_status = "是";
                            }
                        }

                        if (extractedData) {
                            const allData = {
                                ...extractedData,
                                thisStep: thisStep,
                                applyPurchaseDate: applyPurchaseDate,
                                flow_status: flow_status,
                            };
                            console.log("所有数据:", allData);
                            GM_setValue("allData", allData); // 保存所有数据

                            // 调用复制到剪贴板的函数
                            copyDataToClipboard(allData);

                            button.textContent = "获取并保存成功";
                            button.style.backgroundColor = "green";
                        } else {
                            console.warn("extractedData 为空，无法合并数据");
                            button.textContent = "extractedData 为空";
                            button.style.backgroundColor = "orange";
                        }
                        // 提前返回
                    } else {
                        console.warn("未找到表格中的目标元素，请检查选择器");
                        button.textContent = "未找到目标元素";
                        button.style.backgroundColor = "red";
                        // 提前返回
                    }
                } catch (dataError) {
                    console.error("获取表格数据出错:", dataError);
                    button.textContent = "获取表格数据出错";
                    button.style.backgroundColor = "red";
                    // 提前返回
                }

            }, 1000); // 延迟 1 秒
        } catch (error) {
            console.error("点击流转列表时出错:", error);
            button.textContent = "点击流转列表出错";
            button.style.backgroundColor = "red";
        }
    }

    // 将数据复制到剪贴板的函数
    function copyDataToClipboard(data) {
        if (!data) {
            console.warn("没有数据可以复制到剪贴板");
            return;
        }
        // 清理数据
        const amountSource = removeInvisibleCharactersAndSpaces(data.amountSource);
        const applyUserStr = removeInvisibleCharactersAndSpaces(data.applyUserStr);
        const projectName = removeInvisibleCharactersAndSpaces(data.projectName);
        const orgInnerCode = removeInvisibleCharactersAndSpaces(data.orgInnerCode);
        let applyPurchaseDate = removeInvisibleCharactersAndSpaces(data.applyPurchaseDate);
        const projectType = removeInvisibleCharactersAndSpaces(data.projectType);
        const purchaseType = removeInvisibleCharactersAndSpaces(data.purchaseType);
        const purchaseWay = removeInvisibleCharactersAndSpaces(data.purchaseWay);
        const estimatedAmount = removeInvisibleCharactersAndSpaces(data.estimatedAmount);
		if (data.flow_status == '否') {
			applyPurchaseDate = '日期';
		}

        const textToCopy = [(amountSource || "").trim(),
            "=IF([@申请人]=\"\",\"未找到对应部门\",XLOOKUP([@申请人],人员名单及部门列表!A:A,人员名单及部门列表!B:B,\"未找到对应部门\",0))",
            applyUserStr || "", (projectName || "").trim(), (orgInnerCode || "").trim(),
            applyPurchaseDate || "", data.flow_status || "", "否",
            "=IF(AND([@采购审批完成时间]>=TODAY()-WEEKDAY(TODAY(),2)+1,[@采购审批完成时间]<=TODAY()-WEEKDAY(TODAY(),2)+7),\"是\",\"否\")",
            "2025", "=IF([@采购审批完成时间]=\"\",\"\\\",TEXT(MONTH([@采购审批完成时间]),\"00\"))", projectType || "",
            purchaseType || "", purchaseWay || "", estimatedAmount || ""].join("\t");  // 使用制表符连接

        GM_setClipboard(textToCopy, "text");
        console.log("数据已复制到剪贴板:", textToCopy);
    }

    // 更新按钮状态
    function updateButtonState(button, isFetching) {
        if (isFetching) {
            button.textContent = "获取中...";
            button.style.backgroundColor = "#f44336";
        } else {
            button.style.backgroundColor = "#4caf50";  // 恢复默认颜色
        }
    }

    // 去除字符串中的不可见字符和空格和换行
    function removeInvisibleCharactersAndSpaces(str) {
        if (!str) return "";
        return str.replace(/[\u200B-\u200D\uFEFF\s\n]+/g, '');
    }

    // 等待页面加载完成后添加按钮
    if (document.readyState === "complete" || document.readyState === "interactive") {
        setTimeout(() => {
            addButton1();
            addButton2();
        }, 1000);
    } else {
        document.addEventListener("DOMContentLoaded", function () {
            setTimeout(() => {
                addButton1();
                addButton2();
            }, 1000);
        });
    }
})();
